/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTTPCACHE_ABSTRACTRESPONSEWRITER_H_
#define HTTPCACHE_ABSTRACTRESPONSEWRITER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <ace/config-lite.h>
#include <ace/Basic_Types.h> // for ssize_t
#include <memory>
#include <stddef.h>

namespace HttpCache
{

class AbstractResponseWriter
{
public:
	virtual ~AbstractResponseWriter() {}
	
	/**
	 * \brief Writes body data in chunks.
	 * \return Number of bytes written, 0 on EOF or -1 on error.
	 */
	virtual ssize_t writeBodyData(void const* buf, size_t len) = 0;
	
	/**
	 * \brief To be called when all the data has been written.
	 */
	virtual void commit() = 0;
};

} // namespace HttpCache

#endif
