/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTTPCACHE_FILEID_H_
#define HTTPCACHE_FILEID_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HashValue.h"
#include "types.h"
#include <string>
#include <iosfwd>

namespace HttpCache
{

class FileId
{
public:
	typedef HashValue<20> Key;
	
	// Member-wise copying is OK.
	
	FileId(Key const& key, uint32_t version)
	: m_key(key), m_version(version) {}
	
	Key const& getKey() const { return m_key; }
	
	uint32_t getVersion() const { return m_version; }
	
	std::string toFileName() const;
	
	void fileNameToStream(std::ostream& strm) const;
	
	/**
	 * \brief Compare two FileIds.
	 * \return -1 id *this precedes \p rhs, 1 if \p rhs precedes *this,
	 *         or 0 if *this and rhs are equivalent.
	 * \note Items are ordered by m_key ASC, m_version DESC, so that higher
	 *       versions precede lower versions of the same key.
	 */
	int compare(FileId const& rhs) const;
	
	bool operator==(FileId const& rhs) const {
		return compare(rhs) == 0;
	}
	
	bool operator!=(FileId const& rhs) const {
		return compare(rhs) != 0;
	}
	
	bool operator<(FileId const& rhs) const {
		return compare(rhs) < 0;
	}
	
	bool operator>(FileId const& rhs) const {
		return compare(rhs) > 0;
	}
	
	bool operator<=(FileId const& rhs) const {
		return compare(rhs) <= 0;
	}
	
	bool operator>=(FileId const& rhs) const {
		return compare(rhs) >= 0;
	}
private:
	Key m_key;
	uint32_t m_version;
};

} // namespace HttpCache

#endif
