/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTTPCACHE_FILESTORAGE_H_
#define HTTPCACHE_FILESTORAGE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "AbstractFileStorage.h"
#include "LimitedSpaceManager.h"
#include "FileId.h"
#include "IntrusivePtr.h"
#include "AtomicCounter.h"
#include "AbstractCommand.h"
#include "types.h"
#include <ace/config-lite.h>
#include <ace/Basic_Types.h>
#include <map>
#include <memory>

namespace HttpCache
{

class AbstractFileIO;

class FileStorage : public AbstractFileStorage
{
	DECLARE_NON_COPYABLE(FileStorage)
private:
	/**
	 * \brief The constructor is private, use FileStorage::create() instead.
	 */
	FileStorage(std::string const& dir, uint64_t space_limit,
		IntrusivePtr<AbstractCommand> const& gc_invoker);
public:
	virtual ~FileStorage();
	
	/**
	 * \brief Create a storage in the specified directory.
	 * \note \p gc_invoker may be null.
	 * \throw std::runtime_error If the directory could not be opened or has
	 *        wrong permissions.
	 */
	static IntrusivePtr<AbstractFileStorage> create(
		std::string const& dir, uint64_t space_limit,
		IntrusivePtr<AbstractCommand> const& gc_invoker);
	
	virtual void ref() const;
	
	virtual void unref() const;
	
	virtual IntrusivePtr<SpaceManager> const& spaceManager();
	
	virtual std::auto_ptr<AbstractFileIO> openExisting(FileId const& id, Mode mode);
	
	virtual std::auto_ptr<AbstractFileIO> createNew(FileId const& id, Mode mode);
	
	virtual bool unlink(FileId const& id);
private:
	static int translateMode(Mode mode);
	
	IntrusivePtr<SpaceManager> m_ptrSpaceManager;
	std::string m_dirPath;
	mutable AtomicCounter<ACE_MT_SYNCH> m_numRefs;
};

} // namespace HttpCache

#endif
