/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef LINK_H_
#define LINK_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include <gtkmm/eventbox.h>
#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

namespace Gtk
{
	class Label;
}

namespace GtkGUI
{

class Link : public Gtk::EventBox
{
	DECLARE_NON_COPYABLE(Link)
public:
	Link(Glib::ustring const& text);
	
	~Link();
	
	sigc::signal<void>& signalClicked() { return m_signalClicked; }
private:
	virtual void on_map();
	
	virtual bool on_button_release_event(GdkEventButton* evt);
	
	Gtk::Label* m_pLabel;
	sigc::signal<void> m_signalClicked;
};

} // namespace GtkGUI

#endif
