/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "LogWidget.h"
#include "Log.h"
#include "StyledText.h"
#include <deque>

using namespace std;

namespace wxGUI
{

LogWidget::LogWidget(
	Log* log, wxWindow* parent, wxWindowID id, wxString const& value,
	wxPoint const& pos, wxSize const& size, long style,
	wxValidator const& validator, wxString const& name)
:	wxTextCtrl(parent, id, value, pos, size, style, validator, name),
	m_pLog(log)
{
	loadTextFromLog();
	m_pLog->attachObserver(this);
}

LogWidget::~LogWidget()
{
	m_pLog->detachObserver(this);
}

void
LogWidget::appendText(StyledText const& text)
{
	doAppendText(text);
}

void
LogWidget::clear()
{
	Clear();
}

void
LogWidget::doAppendText(StyledText const& text)
{
	SetDefaultStyle(text.style());
	AppendText(text.text());
	ScrollPages(1);
}

void
LogWidget::loadTextFromLog()
{
	deque<StyledText>::const_iterator it = m_pLog->getText().begin();
	deque<StyledText>::const_iterator const end = m_pLog->getText().end();
	for (; it != end; ++it) {
		doAppendText(*it);
	}
}

} // namespace wxGUI
