/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef LOCATIONUPDATER_H_
#define LOCATIONUPDATER_H_

#include "NetworkPrefs.h"
#include "RefPtr.h"

class LocationUpdater : public NetworkPrefs
{
	DECLARE_NON_COPYABLE(LocationUpdater)
public:
	LocationUpdater();
	
	~LocationUpdater();

	void updateLocations(int listen_port);
private:
	void handleLocationPair(
		StringRef const& orig_set_id, StringRef const& orig_set_name,
		StringRef const& bf_set_id, StringRef const& bf_set_name,
		int listen_port);
	
	void createBfLocation(
		int listen_port, StringRef const& orig_set_id,
		StringRef const& new_set_name,
		StringRef const& new_set_id_hint = StringRef());
	
	void modifyServiceForBF(StringRef const& service_path, int listen_port);
	
	CFStringRef m_bfPrefix;
};

#endif
