#=======================================================================
# Makefile for bibindex and biblook.
#
# These programs are written in ISO/ANSI Standard C.  They must be
# compiled with a Standard C compiler, or with a C++ compiler.
#
# This makefile is intended for use with MinGW, a Win32 port of
# gcc. It was tested with the release version current as of 
# February, 2000 (2.95.2). The compiler and documentation is available
# from http://www.mingw.org/
#
# Current target list:
#   all             make bibindex and biblook
#   bibindex        make indexing program
#   biblook         make lookup program
#
# Preprocessor symbol definitions that you might want to change:
#
# CC        see the small selection below of recommended settings.
#
# DEF_H_FILES   On non-UNIX systems, if your system has the include file
#       netinet/in.h, define HAVE_NETINET_IN_H (this symbol is
#       automatically defined on UNIX), since all (we hope)
#       such systems have that include file.  When
#       HAVE_NETINET_IN_H is defined and non-zero, the .bix
#       file is read and written in network byte order,
#       allowing it to be shared between big-endian and
#       little-endian architectures on the same network.  If
#       you don't require this feature, then you can define
#       HAVE_NETINET_IN_H to 0 at compile time.  Since
#       heterogeneous networks are common at many sites, the
#       default is to use network byte order.
#
#       If your site has malloc.h (most UNIX systems do), add
#       -DHAVE_MALLOC_H.
#
#       If your site has stdlib.h, but not yet a Standard C compiler,
#       add -DHAVE_STDLIB_H.
#
# DEST      root directory of local binaries and man pages
#
# MORE      use pg, more, or less for output paging (NB: see security
#       remarks there)
#
# Numerous other preprocessor symbols are defined below, but are
# unlikely to need modifications.
#
# [13-Sep-1993]
#=======================================================================

DEST        = .

# Compilation with a C++ compiler is preferable.
CC      = gcc $(GCCFLAGS)   ## GNU C
CC      = g++ $(GCCFLAGS)   ## GNU C++
# Pick your compiler by copying its line here.
CC      = g++ $(GCCFLAGS)   ## GNU C

# optimization flag -O2 reduces size of .exe files
GCCFLAGS    = -Wall -Wshadow -Wcast-qual -Wpointer-arith \
          -Wwrite-strings -O2 -DMSDOS

DEFINES     = $(DEF_H_FILES) $(DEF_MAXRESULTS) $(DEF_MORE)

# Pick one of these; see the comments above.

DEF_H_FILES = -DHAVE_MALLOC_H -DHAVE_NETINET_IN_H=0
DEF_H_FILES = -DHAVE_MALLOC_H

# Maximum number of bibliographic entries that can be displayed
# A remote lookup service may wish to reduce this limit to prevent
# fetching of large chunks of a bibliography data base.
DEF_MAXRESULTS  = -DMAXRESULTS=500
DEF_MAXRESULTS  =       ## use built-in defaults

# Use more unless env variable PAGER set. 
# e.g. to use less: set PAGER="less" in autoexec.bat or NT environment.
# NB: Security note: if you set up a service like the "telnet biblio"
# facility on siggraph.org, make sure that you take precautions to
# ensure that the shell escape facility of these pagers cannot give
# a remote user a separate login session!  You can for example use
# the restricted shell (/usr/lib/rsh), and launch biblook from the
# .profile file.
DEF_MORE    =  -DMORE=\"less\"  ## use less by default
DEF_MORE    =       ## use built-in defaults

# This setting is suitable for ftp.math.utah.edu:

LDFLAGS     =

LIBS        =


RM      = c:/bin/rm -f

SHELL       = c:/bin/sh

VERSION     = -2-9-1

#=======================================================================

all:    bibindex biblook

bibindex:   bibindex.o
	$(CC) $(CFLAGS) -o bibindex.exe bibindex.o $(LDFLAGS) $(LIBS)

biblook:    biblook.o
	$(CC) $(CFLAGS) -o biblook.exe biblook.o $(LDFLAGS) $(LIBS)

bibindex.o biblook.o: biblook.h

#=======================================================================
