;*=====================================================================*/
;*    serrano/prgm/project/bigloo/api/mail/src/Llib/utils.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue May 17 07:32:37 2005                          */
;*    Last change :  Wed May 18 14:09:12 2005 (serrano)                */
;*    Copyright   :  2005 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    Mail utils                                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __mail_utils

   (export (mail-header->list::pair-nil ::bstring)
	   (email-normalize::bstring ::bstring)))

;*---------------------------------------------------------------------*/
;*    mail-header->list ...                                            */
;*---------------------------------------------------------------------*/
(define (mail-header->list header)
   (define value-grammar
      (regular-grammar ()
	 ((+ (or (out "\r\n") (: (or "\r\n" "\n") (in " \t"))))
	  (the-string))
	 ((+ "\r\n")
	  "")
	 (else
	  (let ((c (the-failure)))
	     (if (eof-object? c)
		 '()
		 (raise (instantiate::&io-parse-error
			   (proc 'header->list)
			   (msg "Illegal character")
			   (obj (string #\[ c #\])))))))))
   (define field-grammar
      (regular-grammar ((id (+ (out ":\n\t\r ,;"))))
	 ((bol (: id ":" (? " ")))
	  (let* ((id (string->symbol
		      (string-downcase!
		       (the-substring 0 (-fx (the-length) 2)))))
		 (val (read/rp value-grammar (the-port))))
	     (cons (cons id val) (ignore))))
	 ((or #\Return #\Newline)
	  (ignore))
	 (else
	  (let ((c (the-failure)))
	     (if (eof-object? c)
		 '()
		 (raise (instantiate::&io-parse-error
			   (proc 'header->list:field-grammar)
			   (msg "Illegal character")
			   (obj (string #\[ c #\])))))))))
   (bind-exit (return)
      (with-exception-handler
	 (lambda (e)
	    (return '()))
	 (lambda ()
	    (with-input-from-string header
	       (lambda ()
		  (read/rp field-grammar (current-input-port))))))))
		 
;*---------------------------------------------------------------------*/
;*    email-normalize ...                                              */
;*---------------------------------------------------------------------*/
(define (email-normalize from)
   (let ((len (string-length from)))
      (cond
	 ((<=fx len 1)
	  from)
	 ((char=? (string-ref from (-fx len 1)) #\>)
	  (let liip ((i (-fx len 1)))
	     (cond
		((=fx i 0)
		 from)
		((char=? (string-ref from i) #\<)
		 (substring from (+fx i 1) (-fx len 1)))
		(else
		 (liip (-fx i 1))))))
	 ((char=? (string-ref from (-fx len 1)) #\))
	  (let liip ((i (-fx len 1)))
	     (cond
		((=fx i 0)
		 from)
		((char=? (string-ref from i) #\()
		 (let loop ((i i))
		    (cond
		       ((=fx i 0)
			from)
		       ((char-whitespace? (string-ref from i))
			(loop (-fx i 1)))
		       (else
			(substring from 0 (-fx i 1))))))
		(else
		 (liip (-fx i 1))))))
	 (else
	  from))))
