;*=====================================================================*/
;*    serrano/prgm/project/bigloo/api/web/src/Llib/html.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue May 17 08:16:28 2005                          */
;*    Last change :  Mon Jun 26 09:34:53 2006 (serrano)                */
;*    Copyright   :  2005-06 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    HTML helpers                                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __web_html
   
   (import __web_xml)
   
   (export (html-parse::pair-nil ::input-port
				 #!optional
				 (clength::int 0)
				 (proc::procedure list))
	   (html-string-decode::bstring ::bstring)
	   (html-string-encode::bstring ::bstring)))

;*---------------------------------------------------------------------*/
;*    *html-special-elements* ...                                      */
;*---------------------------------------------------------------------*/
(define *html-special-elements*
   `((meta)
     (link)
     (br) (hr) (img) (input) (li) (p) (colgroup)
     (option)
;*      (dd) (dt)                                                      */
;*      (body) (head) (html) (tbody) (td) (tfoot) (th) (thead) (tr)    */
     (script . ,html-parse-script)))

;*---------------------------------------------------------------------*/
;*    html-parse ...                                                   */
;*---------------------------------------------------------------------*/
(define (html-parse port #!optional
		    (clength::int 0)
		    (proc::procedure list))
   (xml-parse port clength proc *html-special-elements* #f))

;*---------------------------------------------------------------------*/
;*    html-parse-script ...                                            */
;*---------------------------------------------------------------------*/
(define (html-parse-script iport)
   (let* ((sp (input-port-position iport))
	  (g (regular-grammar ()
		((: "\"" (* (or (out #a000 #\\ #\") (: #\\ all))) "\"")
		 (let ((s (the-substring 1 (-fx (the-length) 1))))
		    (cons (string-append "\"" (string-for-read s) "\"")
			  (ignore))))
		((: "\'" (* (or (out #a000 #\\ #\') (: #\\ all))) "\'")
		 (let ((s (the-substring 1 (-fx (the-length) 1))))
		    (cons (string-append "\'" (string-for-read s) "\'")
			  (ignore))))
		((: "//" (* all))
		 (ignore))
		((: "/*" (* (or (out #\*) (: #\* (out "/")))) "*/")
		 (ignore))
		((+ (out "<"))
		 (let ((s (the-string)))
		    (cons s (ignore))))
		(#\<
		 (let ((s (the-string)))
		    (cons s (ignore))))
		((uncase "</script>")
		 '())  
		(else
		 (let ((char (the-failure)))
		    (raise
		     (instantiate::&io-parse-error
			(proc 'xml-parse)
			(msg (if (eof-object? char)
				 "Premature end of file"
				 "Unclosed list"))
			(obj (if (eof-object? char)
				 char
				 (string-append "{" (string char) "}")))
			(fname (input-port-name iport))
			(location (input-port-position iport)))))))))
      (let ((exp (read/rp g iport)))
	 (cond
	    ((null? exp)
	     '())
	    ((null? (cdr exp))
	     exp)
	    (else
	     (list (apply string-append exp)))))))

;*---------------------------------------------------------------------*/
;*    html-string-decode ...                                           */
;*---------------------------------------------------------------------*/
(define (html-string-decode str)
   (define (count str ol)
      (let loop ((i 0)
		 (c 0))
	 (cond
	    ((=fx i ol)
	     c)
	    ((char=? (string-ref str i) #\&)
	     (cond
		((substring-at? str "&lt;" i)
		 (loop (+fx i 4) (+fx c 1)))
		((substring-at? str "&gt;" i)
		 (loop (+fx i 4) (+fx c 1)))
		((substring-at? str "&amp;" i)
		 (loop (+fx i 5) (+fx c 1)))
		((substring-at? str "&quot;" i)
		 (loop (+fx i 6) (+fx c 1)))
		(else
		 (loop (+fx i 1) (+fx c 1)))))
	    (else
	     (loop (+fx i 1) (+fx c 1))))))
   (define (decode str ol nl)
      (if (=fx ol nl)
	  str
	  (let ((res (make-string nl)))
	     (let loop ((i 0)
			(j 0))
		(cond
		   ((=fx i ol)
		    res)
		   ((char=? (string-ref str i) #\&)
		    (cond
		       ((substring-at? str "&lt;" i)
			(string-set! res j #\<)
			(loop (+fx i 4) (+fx j 1)))
		       ((substring-at? str "&gt;" i)
			(string-set! res j #\>)
			(loop (+fx i 4) (+fx j 1)))
		       ((substring-at? str "&amp;" i)
			(string-set! res j #\&)
			(loop (+fx i 5) (+fx j 1)))
		       ((substring-at? str "&quot;" i)
			(string-set! res j #\")
			(loop (+fx i 6) (+fx j 1)))
		       (else
			(string-set! res j (string-ref str i))
			(loop (+fx i 1) (+fx j 1)))))
		   (else
		    (string-set! res j (string-ref str i))
		    (loop (+fx i 1) (+fx j 1))))))))
   (let ((ol (string-length str)))
      (if (>=fx ol 3)
	  (decode str ol (count str ol))
	  str)))

;*---------------------------------------------------------------------*/
;*    html-string-encode ...                                           */
;*---------------------------------------------------------------------*/
(define (html-string-encode str)
   (define (count str ol)
      (let loop ((i 0)
		 (n 0))
	 (if (=fx i ol)
	     n
	     (let ((c (string-ref str i)))
		(case c
		   ((#\")
		    (loop (+fx i 1) (+fx n 6)))
		   ((#\&)
		    (loop (+fx i 1) (+fx n 5)))
		   ((#\< #\>)
		    (loop (+fx i 1) (+fx n 4)))
		   (else
		    (loop (+fx i 1) (+fx n 1))))))))
   (define (encode str ol nl)
      (if (=fx nl ol)
	  str
	  (let ((res (make-string nl)))
	     (let loop ((i 0)
			(j 0))
		(if (=fx j nl)
		    res
		    (let ((c (string-ref str i)))
		       (case c
			  ((#\<)
			   (blit-string! "&lt;" 0 res j 4)
			   (loop (+fx i 1) (+fx j 4)))
			  ((#\>)
			   (blit-string! "&gt;" 0 res j 4)
			   (loop (+fx i 1) (+fx j 4)))
			  ((#\&)
			   (blit-string! "&amp;" 0 res j 5)
			   (loop (+fx i 1) (+fx j 5)))
			  ((#\")
			   (blit-string! "&quot;" 0 res j 6)
			   (loop (+fx i 1) (+fx j 6)))
			  (else
			   (string-set! res j c)
			   (loop (+fx i 1) (+fx j 1))))))))))
   (let ((ol (string-length str)))
      (encode str ol (count str ol))))
	 
