;*=====================================================================*/
;*    serrano/prgm/project/bigloo/recette/wind.scm                     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Mar  8 19:31:00 1998                          */
;*    Last change :  Tue Oct  4 13:54:16 2005 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Wind test (dynamic-wind and unwind-protect).                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module wind
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-wind)))

;*---------------------------------------------------------------------*/
;*    A global variable                                                */
;*---------------------------------------------------------------------*/
(define *kont* #unspecified)

;*---------------------------------------------------------------------*/
;*    test-unwind ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-unwind)
   (let ((x 3))
      (call/cc (lambda (exit)
		  (unwind-protect
		     (begin
			(set! x (+ 1 x))
			(exit (begin (set! x (+ 1 x)) x))
			(set! x (+ 1 x)))
		     (set! x (+ 1 x)))))
      x))

;*---------------------------------------------------------------------*/
;*    test-wind ...                                                    */
;*---------------------------------------------------------------------*/
(define (test-wind)
   (let ((exg ($get-exitd-top)))
      (test-module "wind" "wind.scm")
      (test "unwind-protect" (test-unwind) 6)
      (when-call/cc (test-wind2))
      (test "dynamic-wind" exg ($get-exitd-top))))

;*---------------------------------------------------------------------*/
;*    test-wind2 ...                                                   */
;*---------------------------------------------------------------------*/
(define (test-wind2)
   (let ((ex ($get-exitd-top)))
      (test "unwind-protect"
	    (let* ((x     10)
		   (value (unwind-protect
			     (call/cc (lambda (exit)
					 (begin
					    (set! x (+ 1 x))
					    (set! *kont* exit)
					    (set! x (+ 1 x)))))
			     (set! x (+ 1 x)))))
	       (if (not (eq? value 4))
		   (*kont* 4)
		   x))
	    14)
      (test "unwind-protect" ex ($get-exitd-top))
      (test "unwind-protect"
	    (let* ((x     10)
		   (value (unwind-protect
			     (call/cc (lambda (exit)
					 (begin
					    (set! x (+ 1 x))
					    (set! *kont* exit)
					    (set! x (+ 1 x)))))
			     (set! x (+ 1 x)))))
	       (if (not (eq? value 4))
		   (*kont* 4)
		   x))
	    14)
      (test "unwind-protect" ex ($get-exitd-top)))
   (test "dynamic-wind"
	 (let ((path '())
	       (c    #f))
	    (let ((add (lambda (s) (set! path (cons s path)))))
	       (dynamic-wind
		  (lambda () (add 'connect))
		  (lambda ()
		     (add (call/cc
			   (lambda (c0)
			      (set! c c0)
			      'talk1))))
		  (lambda ()
		     (add 'disconnect)))
	       (if (< (length path) 4)
		   (c 'talk2)
		   (reverse path))))
	 (let ((path '())
	       (c    #f))
	    (let ((add (lambda (s) (set! path (cons s path)))))
	       (dynamic-wind
		  (lambda () (add 'connect))
		  (lambda ()
		     (add (call/cc
			   (lambda (c0)
			      (set! c c0)
			      'talk1))))
		  (lambda ()
		     (add 'disconnect)))
	       (if (< (length path) 4)
		   (c 'talk2)
		   (reverse path)))))
   (test "dynamic-wind"
	 (let ((path '())
	       (c    #f))
	    (let ((add (lambda (s) (set! path (cons s path)))))
	       (dynamic-wind
		  (lambda () (add 'connect))
		  (lambda ()
		     (add (call/cc
			   (lambda (c0)
			      (set! c c0)
			      'talk1))))
		  (lambda ()
		     (add 'disconnect)))
	       (if (< (length path) 4)
		   (c 'talk2)
		   (reverse path))))
	 '(connect talk1 disconnect connect talk2 disconnect)))

