/*
 * Biloba
 * Copyright (C) 2004-2005 Guillaume Demougeot, Colin Leroy
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#ifndef __MINGW32__
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#else
#include <winsock2.h>
#endif

#ifndef MSG_NOSIGNAL
#define MSG_NOSIGNAL 0
#endif

#define NET_HOST "paperstreet.colino.net"
#define NET_PORT 8000

int send_msg(int fd, const void* buf, unsigned char len)
{
	int rem = len;
	int sent = 0;
	
	sent = (int)send(fd, &len, 1, MSG_NOSIGNAL);
	if (sent < 1) {
		printf("send error : %d\n", sent);
		return -1;
	}
	
	do {
		sent = (int)send(fd, buf, (size_t)rem, MSG_NOSIGNAL);
		if (sent < 0) {
			printf("send error (2): %d\n", sent);
			rem = 0;
			return -1;
		} else {
			rem -= sent;
			buf += sent;
		}
	} while (rem > 0);
	return len;
}

int read_msg(int fd, void *buf, unsigned char avail, unsigned char *len)
{
	int readlen = 0;
	unsigned char gotlen = 0;
	int rem = 0;
	
	memset (buf, 0, (size_t)avail);
	readlen = recv(fd, &gotlen, 1, MSG_NOSIGNAL);

	if (readlen < 1) {
		printf("recv error: %d\n", readlen);
		*len = 0;
		return -1;
	}
	
	rem = gotlen;
	if (rem > 255 || rem > avail) {
		printf("recv: overflow (%d)\n", rem);
		*len = 0;
		return -1;
	}
	
	do {
		readlen = recv(fd, buf, rem, MSG_NOSIGNAL);
		if (readlen < 0) {
			printf("recv error (2): %d\n", readlen);
			*len = 0;
			return -1;
		} else {
			rem -= readlen;
			buf += readlen;
		}
	} while (rem > 0);
	
	*len = gotlen;
	
	return gotlen;
}
