// ShellExt.cpp : Implementation of CShellExt
#include <atlconv.h>  // for ATL string conversion macros
#include "stdafx.h"
#include "Bcshellext.h"
#include "ShellExt.h"

#define MAX_CMD_LINE_LEN 2000

/////////////////////////////////////////////////////////////////////////////
// CShellExt
HRESULT CShellExt::Initialize ( 
    LPCITEMIDLIST pidlFolder,
    LPDATAOBJECT pDataObj,
    HKEY hProgID )
{
    FORMATETC fmt = { CF_HDROP, NULL, DVASPECT_CONTENT, -1, TYMED_HGLOBAL };
    STGMEDIUM stg = { TYMED_HGLOBAL };
    HDROP     hDrop;
    char      szFile[MAX_PATH];
    int       count;

    // Look for CF_HDROP data in the data object.
    if ( FAILED( pDataObj->GetData ( &fmt, &stg )))
    {
        // Nope! Return an "invalid argument" error back to Explorer.
        return E_INVALIDARG;
    }

    // Get a pointer to the actual data.
    hDrop = (HDROP) GlobalLock ( stg.hGlobal );

    // Make sure it worked.
    if ( NULL == hDrop )
    {
        return E_INVALIDARG;
    }


    // Sanity check  make sure there is at least one filename.
    UINT uNumFiles = DragQueryFile ( hDrop, 0xFFFFFFFF, NULL, 0 );

    if ( 0 == uNumFiles )
    {
        GlobalUnlock ( stg.hGlobal );
        ReleaseStgMedium ( &stg );
        return E_INVALIDARG;
    }

    HRESULT hr = S_OK;

    oFileList.clear();
    count = DragQueryFile ( hDrop, -1, NULL, NULL);
    for(int i = 0; i < count; i++)
    {
       // Get the name of the first file and store it in our member variable m_szFile.
       if ( 0 == DragQueryFile ( hDrop, i, szFile, MAX_PATH ))
       {
          hr = E_INVALIDARG;
          break;
       }
       oFileList.push_back(string(szFile));
    }

    GlobalUnlock ( stg.hGlobal );
    ReleaseStgMedium ( &stg );

    return hr;
}

HRESULT CShellExt::QueryContextMenu (
    HMENU hmenu,
    UINT  uMenuIndex, 
    UINT  uidFirstCmd,
    UINT  uidLastCmd,
    UINT  uFlags )
{
    // If the flags include CMF_DEFAULTONLY then we shouldn't do anything.
    if ( uFlags & CMF_DEFAULTONLY )
    {
        return MAKE_HRESULT ( SEVERITY_SUCCESS, FACILITY_NULL, 0 );
    }

    InsertMenu ( hmenu, uMenuIndex, MF_BYPOSITION, uidFirstCmd, _T("Bitzi Lookup") );

    return MAKE_HRESULT ( SEVERITY_SUCCESS, FACILITY_NULL, 1 );
}


HRESULT CShellExt::GetCommandString (
    UINT  idCmd,
    UINT  uFlags,
    UINT* pwReserved,
    LPSTR pszName,
    UINT  cchMax )
{
    USES_CONVERSION;

    // Check idCmd, it must be 0 since we have only one menu item.
    if ( 0 != idCmd )
        return E_INVALIDARG;

    // If Explorer is asking for a help string, copy our string into the
    // supplied buffer.
    if ( uFlags & GCS_HELPTEXT )
        {
        LPCTSTR szText = _T("Submit/lookup this file in the Bitzi catalog.");

        if ( uFlags & GCS_UNICODE )
            {
            // We need to cast pszName to a Unicode string, and then use the
            // Unicode string copy API.
            lstrcpynW ( (LPWSTR) pszName, T2CW(szText), cchMax );
            }
        else
            {
            // Use the ANSI string copy API to return the help string.
            lstrcpynA ( pszName, T2CA(szText), cchMax );
            }

        return S_OK;
        }

    return E_INVALIDARG;
}

HRESULT CShellExt::InvokeCommand ( LPCMINVOKECOMMANDINFO pCmdInfo )
{
    // If lpVerb really points to a string, ignore this function call and bail out.
    if ( 0 != HIWORD( pCmdInfo->lpVerb ))
        return E_INVALIDARG;

    // Get the command index - the only valid one is 0.
    switch ( LOWORD( pCmdInfo->lpVerb ))
        {
        case 0:
            {
            AnalyzeFiles();
            return S_OK;
            }
        break;

        default:
            return E_INVALIDARG;
        break;
        }
}

void CShellExt::AnalyzeFiles(void)
{
    vector<string>::iterator  i;
    string                    argList;
    HKEY                      hKey;
    DWORD                     type;
    char                      exe[MAX_PATH], path[MAX_PATH], *ptr;
    int                       ret;
    DWORD                     size = MAX_PATH;

    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, "Software\\Bitzi", 0, 
        KEY_READ, &hKey) != ERROR_SUCCESS)
    {
        MessageBox(NULL, "Cannot find bitcollider executable", "Error", MB_OK);
        return;
    }

    ret = RegQueryValueEx(hKey, "PluginDir", NULL, &type, (unsigned char*)path, &size);
    if (ret != ERROR_SUCCESS)
    {
        MessageBox(NULL, "Cannot find bitcollider executable", "Error", MB_OK);
        return;
    }

    RegCloseKey(hKey);

    ptr = strrchr(path, '\\');
    if (ptr == NULL)
    {
        MessageBox(NULL, "Cannot find bitcollider executable", "Error", MB_OK);
        return;
    }

    *ptr = 0;
    sprintf(exe, "%s\\bc-gui.exe", path);

    for(i = oFileList.begin(); i != oFileList.end(); i++)
    {
        argList += string("\"") + (*i) + string("\" ");
    }
	if (argList.length() > MAX_CMD_LINE_LEN)
	{
		char  tempPath[MAX_PATH], tempFile[MAX_PATH];
		FILE *temp;

		GetTempPath(MAX_PATH, tempPath);
		GetTempFileName(tempPath, "bp", GetTickCount(), tempFile);

		temp = fopen(tempFile, "w");
		if (temp != NULL)
		{ 
            for(i = oFileList.begin(); i != oFileList.end(); i++)
				fprintf(temp, "%s\n", (*i).c_str());

			fclose(temp);
     		argList = string("@") + string(tempFile);
		}
	}

    ret = (int)ShellExecute(NULL, "open", exe, argList.c_str(), path, SW_SHOW);
    if (ret == SE_ERR_ACCESSDENIED)
    {
        MessageBox(NULL, "You selected too many files. Please try again.", "Error launching Bitcollider", MB_OK);
        return;
    }
    if (ret <= 32)
    {
        sprintf(exe, "Cannot launch the bitcollider executable. (%d)", ret);
        MessageBox(NULL, exe, "Error", MB_OK);
        return;
    }
}
