//  BMP
//  Copyright (C) 2005-2007 BMP development.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glibmm.h>
#include <glibmm/i18n.h>
#include <gtkmm.h>
#include <libglademm.h>

#include <cstring>
#include <iostream>
#include <sstream>
#include <string>

#include <boost/format.hpp>

#include "dialog-gsterror.hh"
#include "paths.hh"
#include "util.hh"
#include "ui-tools.hh"

using namespace Glib;
using namespace Gtk;

namespace Bmp
{
  DialogGstError::~DialogGstError ()
  {}

  DialogGstError*
  DialogGstError::create ()
  {
    const std::string path = BMP_GLADE_DIR G_DIR_SEPARATOR_S "dialog-gsterror.glade";
    RefPtr<Gnome::Glade::Xml> glade_xml = Gnome::Glade::Xml::create (path);
    DialogGstError *dialog = 0;
    glade_xml->get_widget_derived ("dialog-gsterror", dialog);
    return dialog;
  }

  DialogGstError::DialogGstError (BaseObjectType                 * obj,
                                  RefPtr<Gnome::Glade::Xml> const& xml)
  : Dialog    (obj),
    m_ref_xml (xml)
  {
    Util::window_set_icon_list (*this, "player");
  }

  int
  DialogGstError::run (ustring const& text,
                       ustring const& element,
                       ustring const& uri,
                       ustring const& details,
                       ustring const& helpstring,
                       GQuark domain,
                       gint code)

  {
    static boost::format
      id_f ("<big>%s / %2d</big>");

    static boost::format
      b_f ("<b>%s</b>");

    static boost::format
      i_f ("<i>%s</i>");

    dynamic_cast<Label*>(m_ref_xml->get_widget ("label-code"))->set_markup ((id_f % Markup::escape_text (g_quark_to_string(domain)).c_str() % code).str());
    dynamic_cast<Label*>(m_ref_xml->get_widget ("label-main"))->set_markup ((b_f % Markup::escape_text (text).c_str()).str());
    dynamic_cast<Label*>(m_ref_xml->get_widget ("label-element"))->set_markup ((i_f % Markup::escape_text (element).c_str()).str());
    dynamic_cast<Label*>(m_ref_xml->get_widget ("label-uri"))->set_markup ((i_f % Markup::escape_text (uri).c_str()).str());
    dynamic_cast<Label*>(m_ref_xml->get_widget ("label-details"))->set_markup ((i_f % Markup::escape_text (details).c_str()).str());

    if (!helpstring.empty())
    {
      dynamic_cast<Label*>(m_ref_xml->get_widget ("label-helptext"))->set_text (helpstring);
    }
    return Dialog::run ();
  }
} // namespace Bmp
