// StringTokenizer.C  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "StringTokenizer.H"

StringTokenizer::StringTokenizer(String string)
  : st(string), pos(0)
{ }

bool
StringTokenizer::hasMoreTokens()
{
  if (pos == st.length())
    return false;

  for (int i = pos; i < st.length(); i++)
    if (st[i] != ' ' && st[i] != '\t')
      return true;

  return false;
}

bool
StringTokenizer::hasMoreTokens(char c)
{
  if (pos == st.length())
    return false;

  for (int i = pos; i < st.length(); i++)
    if (st[i] != c)
      return true;

  return false;
}

int
StringTokenizer::countTokens()
{
  int i = 0;
  StringTokenizer s(st);
  
  while (s.hasMoreTokens()) {
    s.nextToken();
    i++;
  }

  return i;
}

int
StringTokenizer::countTokens(char c)
{
  int i = 0;
  StringTokenizer s(st);
  
  while (s.hasMoreTokens(c)) {
    s.nextToken(c);
    i++;
  }

  return i;
}

String
StringTokenizer::nextToken()
{
  int i = pos;
  
  while (i < st.length() && (st[i] == ' ' || st[i] == '\t'))
    i++;
  
  for (int j = i; j < st.length(); j++)
    if (st[j] == ' ' || st[j] == '\t') {
      pos = j + 1;
      return st.subString(i, j - 1);
    }

  pos = st.length();
  return st.subString(i, st.length() - 1);
}

String
StringTokenizer::nextToken(char c, bool empty)
{
  int i = pos;

  while (i < st.length() && (st[i] == c))
    i++;
  for (int j = i; j < st.length(); j++)
    if (st[j] == c) {
      pos = j + 1;
      return st.subString(i, j - 1);
    }

  if (empty)
    return "";

  pos = st.length();
  return st.subString(i, st.length() - 1);
}

String
StringTokenizer::rest()
{
  if (pos == st.length())
    return "";

  while (pos < st.length() && (st[pos] == ' ' || st[pos] == '\t'))
    pos++;

  return st.subString(pos, st.length() - 1);
}
