// This file is automatically generated.  Do not edit
#ifndef _H_schema_master_H
#define _H_schema_master_H
extern const char *db_name;
extern int db_is_open;

#ifndef CLIENT
inline int db_open() {
    if (!db_is_open)
        db_is_open=sql_database(db_name);
    return db_is_open;
}
inline int db_close() {
    if (db_is_open)
        db_is_open=!sql_finish();
    return !db_is_open;
}
inline int db_change(const char *name) {
    if(strcmp(db_name, name) || !db_is_open) {
        db_close();
        db_name=name;
        db_open();
    }
    return(db_is_open);
}
#else
inline int db_open() {
    return (db_is_open=1);
}
inline int db_close() {
    return !(db_is_open=0);
}
inline int db_change() {
    return (db_is_open=1);
}
#endif

class  coordinate_t  : public db_type<coordinate_t> {
    public:
        double  time;
        double  ra;
        double  dec;
        coordinate_t();
        coordinate_t(const coordinate_t &a);
        coordinate_t(const SQL_ROW &a);
        coordinate_t(const std::string &s,const char *tag="coordinate_t");
        coordinate_t &operator =(const coordinate_t &a);
        std::string update_format() const;
        std::string insert_format() const;
        std::string select_format() const;
        std::string print(int full_subtables=0, int show_ids=1, int no_refs=0) const;
        std::string print_xml(int full_subtables=1, int show_ids=0, int no_refs=0,const char *tag="coordinate_t") const;
        void parse(const SQL_ROW &s);
        void parse(const std::string &s);
        void parse_xml(const std::string &s,const char *tag="coordinate_t");
    private:
};


class  chirp_parameter_t  : public db_type<chirp_parameter_t> {
    public:
        double  chirp_limit;
        long  fft_len_flags;
        chirp_parameter_t();
        chirp_parameter_t(const chirp_parameter_t &a);
        chirp_parameter_t(const SQL_ROW &a);
        chirp_parameter_t(const std::string &s,const char *tag="chirp_parameter_t");
        chirp_parameter_t &operator =(const chirp_parameter_t &a);
        std::string update_format() const;
        std::string insert_format() const;
        std::string select_format() const;
        std::string print(int full_subtables=0, int show_ids=1, int no_refs=0) const;
        std::string print_xml(int full_subtables=1, int show_ids=0, int no_refs=0,const char *tag="chirp_parameter_t") const;
        void parse(const SQL_ROW &s);
        void parse(const std::string &s);
        void parse_xml(const std::string &s,const char *tag="chirp_parameter_t");
    private:
};


class  subband_description_t  : public db_type<subband_description_t> {
    public:
        long  number;
        double  center;
        double  base;
        double  sample_rate;
        subband_description_t();
        subband_description_t(const subband_description_t &a);
        subband_description_t(const SQL_ROW &a);
        subband_description_t(const std::string &s,const char *tag="subband_description_t");
        subband_description_t &operator =(const subband_description_t &a);
        std::string update_format() const;
        std::string insert_format() const;
        std::string select_format() const;
        std::string print(int full_subtables=0, int show_ids=1, int no_refs=0) const;
        std::string print_xml(int full_subtables=1, int show_ids=0, int no_refs=0,const char *tag="subband_description_t") const;
        void parse(const SQL_ROW &s);
        void parse(const std::string &s);
        void parse_xml(const std::string &s,const char *tag="subband_description_t");
    private:
};


class  data_description_t  : public db_type<data_description_t> {
    public:
        double  start_ra;
        double  start_dec;
        double  end_ra;
        double  end_dec;
        double  true_angle_range;
        char  time_recorded[255];
        double  time_recorded_jd;
        long  nsamples;
        sqlblob<coordinate_t>  coords ;
        data_description_t();
        data_description_t(const data_description_t &a);
        data_description_t(const SQL_ROW &a);
        data_description_t(const std::string &s,const char *tag="data_description_t");
        data_description_t &operator =(const data_description_t &a);
        std::string update_format() const;
        std::string insert_format() const;
        std::string select_format() const;
        std::string print(int full_subtables=0, int show_ids=1, int no_refs=0) const;
        std::string print_xml(int full_subtables=1, int show_ids=0, int no_refs=0,const char *tag="data_description_t") const;
        void parse(const SQL_ROW &s);
        void parse(const std::string &s);
        void parse_xml(const std::string &s,const char *tag="data_description_t");
    private:
};


class  receiver_config  : public db_table<receiver_config> {
    public:
        long  id;
        long  s4_id;
        char  name[255];
        double  beam_width;
        double  center_freq;
        double  latitude;
        double  longitude;
        double  elevation;
        double  diameter;
        double  az_orientation;
        sqlblob<float>  az_corr_coeff ;
        sqlblob<float>  zen_corr_coeff ;
        receiver_config();
        receiver_config(const receiver_config &a);
        receiver_config(const SQL_ROW &a);
        receiver_config(const std::string &s,const char *tag="receiver_config");
        receiver_config &operator =(const receiver_config &a);
        std::string update_format() const;
        std::string insert_format() const;
        std::string select_format() const;
        std::string print(int full_subtables=0, int show_ids=1, int no_refs=0) const;
        std::string print_xml(int full_subtables=1, int show_ids=0, int no_refs=0,const char *tag="receiver_config") const;
        void parse(const SQL_ROW &s);
        void parse(const std::string &s);
        void parse_xml(const std::string &s,const char *tag="receiver_config");
    private:
};


class  recorder_config  : public db_table<recorder_config> {
    public:
        long  id;
        char  name[64];
        long  bits_per_sample;
        double  sample_rate;
        long  beams;
        double  version;
        recorder_config();
        recorder_config(const recorder_config &a);
        recorder_config(const SQL_ROW &a);
        recorder_config(const std::string &s,const char *tag="recorder_config");
        recorder_config &operator =(const recorder_config &a);
        std::string update_format() const;
        std::string insert_format() const;
        std::string select_format() const;
        std::string print(int full_subtables=0, int show_ids=1, int no_refs=0) const;
        std::string print_xml(int full_subtables=1, int show_ids=0, int no_refs=0,const char *tag="recorder_config") const;
        void parse(const SQL_ROW &s);
        void parse(const std::string &s);
        void parse_xml(const std::string &s,const char *tag="recorder_config");
    private:
};


class  splitter_config  : public db_table<splitter_config> {
    public:
        long  id;
        double  version;
        char  data_type[64];
        long  fft_len;
        long  ifft_len;
        char  filter[64];
        char  window[64];
        splitter_config();
        splitter_config(const splitter_config &a);
        splitter_config(const SQL_ROW &a);
        splitter_config(const std::string &s,const char *tag="splitter_config");
        splitter_config &operator =(const splitter_config &a);
        std::string update_format() const;
        std::string insert_format() const;
        std::string select_format() const;
        std::string print(int full_subtables=0, int show_ids=1, int no_refs=0) const;
        std::string print_xml(int full_subtables=1, int show_ids=0, int no_refs=0,const char *tag="splitter_config") const;
        void parse(const SQL_ROW &s);
        void parse(const std::string &s);
        void parse_xml(const std::string &s,const char *tag="splitter_config");
    private:
};


class  analysis_config  : public db_table<analysis_config> {
    public:
        long  id;
        double  spike_thresh;
        long  spikes_per_spectrum;
        double  gauss_null_chi_sq_thresh;
        double  gauss_chi_sq_thresh;
        double  gauss_power_thresh;
        double  gauss_peak_power_thresh;
        long  gauss_pot_length;
        double  pulse_thresh;
        double  pulse_display_thresh;
        long  pulse_max;
        long  pulse_min;
        long  pulse_fft_max;
        long  pulse_pot_length;
        double  triplet_thresh;
        long  triplet_max;
        long  triplet_min;
        long  triplet_pot_length;
        double  pot_overlap_factor;
        double  pot_t_offset;
        double  pot_min_slew;
        double  pot_max_slew;
        double  chirp_resolution;
        long  analysis_fft_lengths;
        long  bsmooth_boxcar_length;
        long  bsmooth_chunk_size;
        sqlblob<chirp_parameter_t>  chirps ;
        double  pulse_beams;
        long  max_signals;
        long  max_spikes;
        long  max_gaussians;
        long  max_pulses;
        long  max_triplets;
        long  keyuniq;
        analysis_config();
        analysis_config(const analysis_config &a);
        analysis_config(const SQL_ROW &a);
        analysis_config(const std::string &s,const char *tag="analysis_config");
        analysis_config &operator =(const analysis_config &a);
        std::string update_format() const;
        std::string insert_format() const;
        std::string select_format() const;
        std::string print(int full_subtables=0, int show_ids=1, int no_refs=0) const;
        std::string print_xml(int full_subtables=1, int show_ids=0, int no_refs=0,const char *tag="analysis_config") const;
        void parse(const SQL_ROW &s);
        void parse(const std::string &s);
        void parse_xml(const std::string &s,const char *tag="analysis_config");
    private:
};


class  tape  : public db_table<tape> {
    public:
        long  id;
        char  name[20];
        double  start_time;
        double  last_block_time;
        long  last_block_done;
        long  missed;
        long  tape_quality;
        long  sb_id;
        tape();
        tape(const tape &a);
        tape(const SQL_ROW &a);
        tape(const std::string &s,const char *tag="tape");
        tape &operator =(const tape &a);
        std::string update_format() const;
        std::string insert_format() const;
        std::string select_format() const;
        std::string print(int full_subtables=0, int show_ids=1, int no_refs=0) const;
        std::string print_xml(int full_subtables=1, int show_ids=0, int no_refs=0,const char *tag="tape") const;
        void parse(const SQL_ROW &s);
        void parse(const std::string &s);
        void parse_xml(const std::string &s,const char *tag="tape");
    private:
};


class  settings  : public db_table<settings> {
    public:
        long  id;
        long  active;
        db_reference<recorder_config,long> recorder_cfg;
        db_reference<splitter_config,long> splitter_cfg;
        db_reference<analysis_config,long> analysis_cfg;
        db_reference<receiver_config,long> receiver_cfg;
        settings();
        settings(const settings &a);
        settings(const SQL_ROW &a);
        settings(const std::string &s,const char *tag="settings");
        settings &operator =(const settings &a);
        std::string update_format() const;
        std::string insert_format() const;
        std::string select_format() const;
        std::string print(int full_subtables=0, int show_ids=1, int no_refs=0) const;
        std::string print_xml(int full_subtables=1, int show_ids=0, int no_refs=0,const char *tag="settings") const;
        void parse(const SQL_ROW &s);
        void parse(const std::string &s);
        void parse_xml(const std::string &s,const char *tag="settings");
    private:
};


class  workunit_grp  : public db_table<workunit_grp> {
    public:
        long  id;
        db_reference<tape,long> tape_info;
        char  name[64];
        data_description_t data_desc;
        db_reference<receiver_config,long> receiver_cfg;
        db_reference<recorder_config,long> recorder_cfg;
        db_reference<splitter_config,long> splitter_cfg;
        db_reference<analysis_config,long> analysis_cfg;
        long  sb_id;
        workunit_grp();
        workunit_grp(const workunit_grp &a);
        workunit_grp(const SQL_ROW &a);
        workunit_grp(const std::string &s,const char *tag="workunit_grp");
        workunit_grp &operator =(const workunit_grp &a);
        std::string update_format() const;
        std::string insert_format() const;
        std::string select_format() const;
        std::string print(int full_subtables=0, int show_ids=1, int no_refs=0) const;
        std::string print_xml(int full_subtables=1, int show_ids=0, int no_refs=0,const char *tag="workunit_grp") const;
        void parse(const SQL_ROW &s);
        void parse(const std::string &s);
        void parse_xml(const std::string &s,const char *tag="workunit_grp");
    private:
};


class  workunit_header  : public db_table<workunit_header> {
    public:
        sqlint8_t  id;
        char  name[64];
        db_reference<workunit_grp,long> group_info;
        subband_description_t subband_desc;
        sqlint8_t  sb_id;
        workunit_header();
        workunit_header(const workunit_header &a);
        workunit_header(const SQL_ROW &a);
        workunit_header(const std::string &s,const char *tag="workunit_header");
        workunit_header &operator =(const workunit_header &a);
        std::string update_format() const;
        std::string insert_format() const;
        std::string select_format() const;
        std::string print(int full_subtables=0, int show_ids=1, int no_refs=0) const;
        std::string print_xml(int full_subtables=1, int show_ids=0, int no_refs=0,const char *tag="workunit_header") const;
        void parse(const SQL_ROW &s);
        void parse(const std::string &s);
        void parse_xml(const std::string &s,const char *tag="workunit_header");
    private:
};


typedef workunit_header workunit;
class  result  : public db_table<result> {
    public:
        sqlint8_t  id;
        sqlint8_t  boinc_result;
        db_reference<workunit_header,sqlint8_t> wuid;
        double  received;
        long  hostid;
        long  versionid;
        long  return_code;
        long  overflow;
        long  reserved;
        sqlint8_t  sb_id;
        result();
        result(const result &a);
        result(const SQL_ROW &a);
        result(const std::string &s,const char *tag="result");
        result &operator =(const result &a);
        std::string update_format() const;
        std::string insert_format() const;
        std::string select_format() const;
        std::string print(int full_subtables=0, int show_ids=1, int no_refs=0) const;
        std::string print_xml(int full_subtables=1, int show_ids=0, int no_refs=0,const char *tag="result") const;
        void parse(const SQL_ROW &s);
        void parse(const std::string &s);
        void parse_xml(const std::string &s,const char *tag="result");
    private:
};


class  triplet  : public db_table<triplet> {
    public:
        sqlint8_t  id;
        db_reference<result,sqlint8_t> result_id;
        double  peak_power;
        double  mean_power;
        double  time;
        double  ra;
        double  decl;
        sqlint8_t  q_pix;
        double  freq;
        double  detection_freq;
        double  barycentric_freq;
        long  fft_len;
        double  chirp_rate;
        long  rfi_checked;
        long  rfi_found;
        long  reserved;
        double  period;
        triplet();
        triplet(const triplet &a);
        triplet(const SQL_ROW &a);
        triplet(const std::string &s,const char *tag="triplet");
        triplet &operator =(const triplet &a);
        std::string update_format() const;
        std::string insert_format() const;
        std::string select_format() const;
        std::string print(int full_subtables=0, int show_ids=1, int no_refs=0) const;
        std::string print_xml(int full_subtables=1, int show_ids=0, int no_refs=0,const char *tag="triplet") const;
        void parse(const SQL_ROW &s);
        void parse(const std::string &s);
        void parse_xml(const std::string &s,const char *tag="triplet");
    private:
};


class  gaussian  : public db_table<gaussian> {
    public:
        sqlint8_t  id;
        db_reference<result,sqlint8_t> result_id;
        double  peak_power;
        double  mean_power;
        double  time;
        double  ra;
        double  decl;
        sqlint8_t  q_pix;
        double  freq;
        double  detection_freq;
        double  barycentric_freq;
        long  fft_len;
        double  chirp_rate;
        long  rfi_checked;
        long  rfi_found;
        long  reserved;
        double  sigma;
        double  chisqr;
        double  null_chisqr;
        double  score;
        double  max_power;
        sqlblob<unsigned char>  pot;
        gaussian();
        gaussian(const gaussian &a);
        gaussian(const SQL_ROW &a);
        gaussian(const std::string &s,const char *tag="gaussian");
        gaussian &operator =(const gaussian &a);
        std::string update_format() const;
        std::string insert_format() const;
        std::string select_format() const;
        std::string print(int full_subtables=0, int show_ids=1, int no_refs=0) const;
        std::string print_xml(int full_subtables=1, int show_ids=0, int no_refs=0,const char *tag="gaussian") const;
        void parse(const SQL_ROW &s);
        void parse(const std::string &s);
        void parse_xml(const std::string &s,const char *tag="gaussian");
    private:
};


class  pulse  : public db_table<pulse> {
    public:
        sqlint8_t  id;
        db_reference<result,sqlint8_t> result_id;
        double  peak_power;
        double  mean_power;
        double  time;
        double  ra;
        double  decl;
        sqlint8_t  q_pix;
        double  freq;
        double  detection_freq;
        double  barycentric_freq;
        long  fft_len;
        double  chirp_rate;
        long  rfi_checked;
        long  rfi_found;
        long  reserved;
        double  period;
        double  snr;
        double  thresh;
        double  score;
        long  len_prof;
        sqlblob<unsigned char>  pot;
        pulse();
        pulse(const pulse &a);
        pulse(const SQL_ROW &a);
        pulse(const std::string &s,const char *tag="pulse");
        pulse &operator =(const pulse &a);
        std::string update_format() const;
        std::string insert_format() const;
        std::string select_format() const;
        std::string print(int full_subtables=0, int show_ids=1, int no_refs=0) const;
        std::string print_xml(int full_subtables=1, int show_ids=0, int no_refs=0,const char *tag="pulse") const;
        void parse(const SQL_ROW &s);
        void parse(const std::string &s);
        void parse_xml(const std::string &s,const char *tag="pulse");
    private:
};


class  pointing  : public db_table<pointing> {
    public:
        long  time_id;
        double  time;
        double  ra;
        double  dec;
        long  q_pix;
        double  angle_range;
        long  bad;
        pointing();
        pointing(const pointing &a);
        pointing(const SQL_ROW &a);
        pointing(const std::string &s,const char *tag="pointing");
        pointing &operator =(const pointing &a);
        std::string update_format() const;
        std::string insert_format() const;
        std::string select_format() const;
        std::string print(int full_subtables=0, int show_ids=1, int no_refs=0) const;
        std::string print_xml(int full_subtables=1, int show_ids=0, int no_refs=0,const char *tag="pointing") const;
        void parse(const SQL_ROW &s);
        void parse(const std::string &s);
        void parse_xml(const std::string &s,const char *tag="pointing");
    private:
};


class  sky_map  : public db_table<sky_map> {
    public:
        sqlint8_t  npix;
        long  qpix;
        long  fpix;
        sqlint8_t  spike_max_id;
        sqlint8_t  gaussian_max_id;
        sqlint8_t  pulse_max_id;
        sqlint8_t  triplet_max_id;
        long  spike_count;
        long  gaussian_count;
        long  pulse_count;
        long  triplet_count;
        long  new_data;
        double  score;
        sky_map();
        sky_map(const sky_map &a);
        sky_map(const SQL_ROW &a);
        sky_map(const std::string &s,const char *tag="sky_map");
        sky_map &operator =(const sky_map &a);
        std::string update_format() const;
        std::string insert_format() const;
        std::string select_format() const;
        std::string print(int full_subtables=0, int show_ids=1, int no_refs=0) const;
        std::string print_xml(int full_subtables=1, int show_ids=0, int no_refs=0,const char *tag="sky_map") const;
        void parse(const SQL_ROW &s);
        void parse(const std::string &s);
        void parse_xml(const std::string &s,const char *tag="sky_map");
    private:
};


class  spike  : public db_table<spike> {
    public:
        sqlint8_t  id;
        db_reference<result,sqlint8_t> result_id;
        double  peak_power;
        double  mean_power;
        double  time;
        double  ra;
        double  decl;
        sqlint8_t  q_pix;
        double  freq;
        double  detection_freq;
        double  barycentric_freq;
        long  fft_len;
        double  chirp_rate;
        long  rfi_checked;
        long  rfi_found;
        long  reserved;
        spike();
        spike(const spike &a);
        spike(const SQL_ROW &a);
        spike(const std::string &s,const char *tag="spike");
        spike &operator =(const spike &a);
        std::string update_format() const;
        std::string insert_format() const;
        std::string select_format() const;
        std::string print(int full_subtables=0, int show_ids=1, int no_refs=0) const;
        std::string print_xml(int full_subtables=1, int show_ids=0, int no_refs=0,const char *tag="spike") const;
        void parse(const SQL_ROW &s);
        void parse(const std::string &s);
        void parse_xml(const std::string &s,const char *tag="spike");
    private:
};


#endif
