// Copyright 2006 Regents of the University of California

// SETI_BOINC is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2, or (at your option) any later
// version.

// SETI_BOINC is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
// more details.

// You should have received a copy of the GNU General Public License along
// with SETI_BOINC; see the file COPYING.  If not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// In addition, as a special exception, the Regents of the University of
// California give permission to link the code of this program with libraries
// that provide specific optimized fast Fourier transform (FFT) functions and
// distribute a linked executable.  You must obey the GNU General Public 
// License in all respects for all of the code used other than the FFT library
// itself.  Any modification required to support these libraries must be
// distributed in source code form.  If you modify this file, you may extend 
// this exception to your version of the file, but you are not obligated to 
// do so. If you do not wish to do so, delete this exception statement from 
// your version.

// This file contains compile time configuration parameters
// for the seti@home reference algorithm implementation.

/* Special config.h file for Macintosh */

#ifndef _SAH_CONFIG_H_
#define _SAH_CONFIG_H_

#ifndef __APPLE_CC__
#error Wrong config.h file!
#endif


/* Version number of package */
#define VERSION "5.13"

/* SETI@home major version number */
#define VERSION_MAJOR 5

/* SETI@home minor version number */
#define VERSION_MINOR 13

/* Define to the full name and version of this package. */
#define PACKAGE_STRING "setiathome_enhanced 5.13"

/* Define to the version of this package. */
#define PACKAGE_VERSION "5.13"

#ifdef __i386__
    /* Define to 1 if you have the gcc_eh library */
    #define HAVE_LIBGCC_EH 1

    /* Define to 1 if long double works and has more range or precision than
       double. */
    #define HAVE_LONG_DOUBLE 1

    /* Define to 1 if stdbool.h conforms to C99. */
    #define HAVE_STDBOOL_H 1

    /* Platform identification used to identify applications for this BOINC core
       client */
    #define HOSTTYPE "i686-apple-darwin"

    /* "Define to 1 if largefile support causes missing symbols in C++" */
    /* #undef LARGEFILE_BREAKS_CXX */

    /* The size of a `long double', as computed by sizeof. */
    #define SIZEOF_LONG_DOUBLE 16

    /* Define to 1 if you want to use SSE optimizations */
    #define USE_SSE 1

    /* Define to 1 if you have the `atanf' function. */
    #define HAVE_ATANF 1

    /* Define to 1 if you have the `cosf' function. */
    #define HAVE_COSF 1

    /* Define to 1 if you have the `sinf' function. */
    #define HAVE_SINF 1

#else

    /* Define to 1 if you have the gcc_eh library */
    /* #undef HAVE_LIBGCC_EH */

    /* Define to 1 if long double works and has more range or precision than
       double. */
    /* #undef HAVE_LONG_DOUBLE */

    /* Define to 1 if stdbool.h conforms to C99. */
    /* #undef HAVE_STDBOOL_H */

    /* Platform identification used to identify applications for this BOINC core
       client */
    #define HOSTTYPE "powerpc-apple-darwin"

    /* "Define to 1 if largefile support causes missing symbols in C++" */
    #define LARGEFILE_BREAKS_CXX 1

    /* The size of a `long double', as computed by sizeof. */
    #define SIZEOF_LONG_DOUBLE 8

    /* Define to 1 if you want to use SSE optimizations */
    /* #undef USE_SSE */

    /* OS < 10.3.9 do not have sinf, cosf, atanf defined
    /* Define to 1 if you have the `atanf' function. */
    /* #undef HAVE_ATANF */

    /* Define to 1 if you have the `cosf' function. */
    /* #undef HAVE_COSF */

    /* Define to 1 if you have the `sinf' function. */
    /* #undef HAVE_SINF */

#endif


/* Define to 1 to build a graphical application */
#define BOINC_APP_GRAPHICS 1

/* Define to 1 if building graphics is a shared library */
/* #undef ENABLE_DLOPEN */

/* Use the Apple OpenGL framework. */
#define HAVE_APPLE_OPENGL_FRAMEWORK 1

/* Define to 1 if you have the `atexit' function. */
#define HAVE_ATEXIT 1

/* Define to 1 if you have the `atoll' function. */
#define HAVE_ATOLL 1

/* Define to 1 if the system has the type `bool'. */
#define HAVE_BOOL 1

/* Define to 1 if you have the <complex.h> header file. */
#define HAVE_COMPLEX_H 1

/* Define to 1 if you have the <dirent.h> header file. */
#define HAVE_DIRENT_H 1

/* Define to 1 if you have the <dlfcn.h> header file. */
#define HAVE_DLFCN_H 1

/* Define to 1 if you have the `dlopen' function. */
#define HAVE_DLOPEN 1

/* Define to 1 if you have the `exit' function. */
#define HAVE_EXIT 1

/* Define to 1 if you have the <fcntl.h> header file. */
#define HAVE_FCNTL_H 1

/* Define to 1 if you have the <fftw3.h> header file. */
#define HAVE_FFTW3_H 1

/* Define to 1 if you have the <floatingpoint.h> header file. */
/* #undef HAVE_FLOATINGPOINT_H */

/* Define to 1 if you have the `floor' function. */
#define HAVE_FLOOR 1

/* Define to 1 if you have the `fork' function. */
#define HAVE_FORK 1

/* Define to 1 if you have the `getcwd' function. */
#define HAVE_GETCWD 1

/* Define to 1 if you have the <glaux.h> header file. */
/* #undef HAVE_GLAUX_H */

/* Define to 1 if you have the <glut/glut.h> header file. */
#define HAVE_GLUT_GLUT_H 1

/* Define to 1 if you have the <glut.h> header file. */
/* #undef HAVE_GLUT_H */

/* Define to 1 if you have the <glu.h> header file. */
/* #undef HAVE_GLU_H */

/* Define to 1 if you have the <GL/glaux.h> header file. */
/* #undef HAVE_GL_GLAUX_H */

/* Define to 1 if you have the <GL/glut.h> header file. */
/* #undef HAVE_GL_GLUT_H */

/* Define to 1 if you have the <GL/glu.h> header file. */
/* #undef HAVE_GL_GLU_H */

/* Define to 1 if you have the <GL/gl.h> header file. */
/* #undef HAVE_GL_GL_H */

/* Define to 1 if you have the <gl.h> header file. */
/* #undef HAVE_GL_H */

/* Define to 1 if you have the <ieeefp.h> header file. */
/* #undef HAVE_IEEEFP_H */

/* Define to 1 if the system has the type `int32_t'. */
#define HAVE_INT32_T 1

/* Define to 1 if the system has the type `int64_t'. */
#define HAVE_INT64_T 1

/* Define to 1 if you have the <inttypes.h> header file. */
#define HAVE_INTTYPES_H 1

/* Define to 1 if you have the aio library */
/* #undef HAVE_LIBAIO */

/* Define to 1 if you have the c library */
#define HAVE_LIBC 1

/* Define to 1 if you have the cygipc library */
/* #undef HAVE_LIBCYGIPC */

/* Define to 1 if you have the dl library */
#define HAVE_LIBDL 1

/* Define to 1 if you have the elf library */
/* #undef HAVE_LIBELF */

/* Define to 1 if you have the fftw3f library */
#define HAVE_LIBFFTW3F 1

/* Define to 1 if you have the gcc library */
#define HAVE_LIBGCC 1

/* Define to 1 if you have the jpeg library */
/* #undef HAVE_LIBJPEG */

/* Define to 1 if you have the math library */
#define HAVE_LIBM 1

/* Define to 1 if you have the nsl library */
/* #undef HAVE_LIBNSL */

/* Define to 1 if you have the pthread library */
#define HAVE_LIBPTHREAD 1

/* Define to 1 if you have the rt library */
/* #undef HAVE_LIBRT */

/* Define to 1 if you have the socket library */
/* #undef HAVE_LIBSOCKET */

/* Define to 1 if you have the stdc++ library */
#define HAVE_LIBSTDC__ 1

/* Define to 1 if you have the z library */
#define HAVE_LIBZ 1

/* Define to 1 if you have the <limits.h> header file. */
#define HAVE_LIMITS_H 1

/* Define to 1 if the system has the type `long long'. */
#define HAVE_LONG_LONG 1

/* Define to 1 if your system has a GNU libc compatible `malloc' function, and
   to 0 otherwise. */
#define HAVE_MALLOC 1

/* Define to 1 if you have the <malloc.h> header file. */
/* #undef HAVE_MALLOC_H */

/* Define to 1 if you have the <math.h> header file. */
#define HAVE_MATH_H 1

/* Define to 1 if you have the `memalign' function. */
/* #undef HAVE_MEMALIGN */

/* Define to 1 if you have the <memory.h> header file. */
#define HAVE_MEMORY_H 1

/* Define to 1 if you have the `memset' function. */
#define HAVE_MEMSET 1

/* Define to 1 if you have the <MesaGL/glaux.h> header file. */
/* #undef HAVE_MESAGL_GLAUX_H */

/* Define to 1 if you have the <MesaGL/glut.h> header file. */
/* #undef HAVE_MESAGL_GLUT_H */

/* Define to 1 if you have the <MesaGL/glu.h> header file. */
/* #undef HAVE_MESAGL_GLU_H */

/* Define to 1 if you have the <MesaGL/gl.h> header file. */
/* #undef HAVE_MESAGL_GL_H */

/* Define to 1 if you have the `munmap' function. */
#define HAVE_MUNMAP 1

/* Define if your C++ compiler supports namespaces */
#define HAVE_NAMESPACES 1

/* Define to 1 if you have the <OpenGL/glaux.h> header file. */
/* #undef HAVE_OPENGL_GLAUX_H */

/* Define to 1 if you have the <OpenGL/glut.h> header file. */
/* #undef HAVE_OPENGL_GLUT_H */

/* Define to 1 if you have the <OpenGL/glu.h> header file. */
#define HAVE_OPENGL_GLU_H 1

/* Define to 1 if you have the <OpenGL/gl.h> header file. */
#define HAVE_OPENGL_GL_H 1

/* Have pthread */
#define HAVE_PTHREAD 1

/* Define to 1 if you have the `putenv' function. */
#define HAVE_PUTENV 1

/* Define to 1 if your system has a GNU libc compatible `realloc' function,
   and to 0 otherwise. */
#define HAVE_REALLOC 1

/* Define to 1 if you have the `sincos' function. */
/* #undef HAVE_SINCOS */

/* Define to 1 if you have the `sincosf' function. */
/* #undef HAVE_SINCOSF */

/* Define to 1 if you have the `sqrt' function. */
#define HAVE_SQRT 1

/* Define to 1 if `stat' has the bug that it succeeds when given the
   zero-length file name argument. */
/* #undef HAVE_STAT_EMPTY_STRING_BUG */

/* Define to 1 if you have the <stdint.h> header file. */
#define HAVE_STDINT_H 1

/* Define to 1 if you have the <stdlib.h> header file. */
#define HAVE_STDLIB_H 1

/* Define to 1 if transform is in namespace std:: */
#define HAVE_STD_TRANSFORM 1

/* Define to 1 if max is in namespace std:: */
#define HAVE_STD_MAX 1

/* Define to 1 if min is in namespace std:: */
#define HAVE_STD_MIN 1

/* Define to 1 if you have the `strchr' function. */
#define HAVE_STRCHR 1

/* Define to 1 if you have the `strftime' function. */
#define HAVE_STRFTIME 1

/* Define to 1 if you have the <strings.h> header file. */
#define HAVE_STRINGS_H 1

/* Define to 1 if you have the <string.h> header file. */
#define HAVE_STRING_H 1

/* Define to 1 if you have the `strstr' function. */
#define HAVE_STRSTR 1

/* Define to 1 if `st_blocks' is member of `struct stat'. */
#define HAVE_STRUCT_STAT_ST_BLOCKS 1

/* Define to 1 if your `struct stat' has `st_blocks'. Deprecated, use
   `HAVE_STRUCT_STAT_ST_BLOCKS' instead. */
#define HAVE_ST_BLOCKS 1

/* Define to 1 if you have the <sys/ioctl.h> header file. */
#define HAVE_SYS_IOCTL_H 1

/* Define to 1 if you have the <sys/statvfs.h> header file. */
#define HAVE_SYS_STATVFS_H 1

/* Define to 1 if you have the <sys/stat.h> header file. */
#define HAVE_SYS_STAT_H 1

/* Define to 1 if you have the <sys/time.h> header file. */
#define HAVE_SYS_TIME_H 1

/* Define to 1 if you have the <sys/types.h> header file. */
#define HAVE_SYS_TYPES_H 1

/* Define to 1 if you have <sys/wait.h> that is POSIX.1 compatible. */
#define HAVE_SYS_WAIT_H 1

/* Define to 1 if you have the <unistd.h> header file. */
#define HAVE_UNISTD_H 1

/* Define to 1 if you have the `vfork' function. */
#define HAVE_VFORK 1

/* Define to 1 if you have the <vfork.h> header file. */
/* #undef HAVE_VFORK_H */

/* Define to 1 if you have the <windows.h> header file. */
/* #undef HAVE_WINDOWS_H */

/* Define to 1 if `fork' works. */
#define HAVE_WORKING_FORK 1

/* Define to 1 if `vfork' works. */
#define HAVE_WORKING_VFORK 1

/* Define to 1 if you have the `_aligned_malloc' function. */
/* #undef HAVE__ALIGNED_MALLOC */

/* Define to 1 if the system has the type `_Bool'. */
/* #undef HAVE__BOOL */

/* Define to 1 if you have the `_exit' function. */
#define HAVE__EXIT 1

/* Define to 1 if the system has the type `_int32'. */
/* #undef HAVE__INT32 */

/* Define to 1 if the system has the type `_int64'. */
/* #undef HAVE__INT64 */

/* Define to 1 if `lstat' dereferences a symlink specified with a trailing
   slash. */
/* #undef LSTAT_FOLLOWS_SLASHED_SYMLINK */

/* Define to 1 if `major', `minor', and `makedev' are declared in <mkdev.h>.
   */
/* #undef MAJOR_IN_MKDEV */

/* Define to 1 if `major', `minor', and `makedev' are declared in
   <sysmacros.h>. */
/* #undef MAJOR_IN_SYSMACROS */

/* Name of package */
#define PACKAGE "setiathome_enhanced"

/* Define to the address where bug reports for this package should be sent. */
#define PACKAGE_BUGREPORT "ports@setiathome.ssl.berkeley.edu"

/* Define to the full name of this package. */
#define PACKAGE_NAME "setiathome_enhanced"

/* Define to the one symbol short name of this package. */
#define PACKAGE_TARNAME "setiathome_enhanced"

/* Define as directory containing the project config.xml */
#define PROJECTDIR "~boincadm/projects/ap"

/* Define to the necessary symbol if this constant uses a non-standard name on
   your system. */
/* #undef PTHREAD_CREATE_JOINABLE */

/* Path to the S4 receiver config file */
/* #undef S4_RECEIVER_CONFIG_FILE */

/* Define to the BOINC application name for setiathome */
#define SAH_APP_NAME "setiathome_enhanced"

/* The size of a `long int', as computed by sizeof. */
#define SIZEOF_LONG_INT 4

/* Define to 1 if you have the ANSI C header files. */
#define STDC_HEADERS 1

/* Define to 1 if your <sys/time.h> declares `struct tm'. */
/* #undef TM_IN_SYS_TIME */

/* Define to 1 if you want to use 3D-Now optimizations */
/* #undef USE_3DNOW */

/* Define to 1 if you want to use the gcc -ffast-math optimization */
#define USE_FAST_MATH 1

/* Define to 1 if informix is installed */
/* #undef USE_INFORMIX */

/* "Define to 1 if you want to use the Intel Performance Primitives" */
/* #undef USE_IPP */

/* Define to 1 if you want to use MMX optimizations */
/* #undef USE_MMX */

/* Define if MYSQL is installed */
/* #undef USE_MYSQL */

/* "Define to 1 if you want to use the openssl crypto library" */
#define USE_OPENSSL 1

/* Define to 1 if you want to use SSE optimizations */
/* #undef USE_SSE */

/* Define to 1 if you want to use SSE2 optimizations */
/* #undef USE_SSE2 */

/* Define to 1 if you want to use SSE3 optimizations */
/* #undef USE_SSE3 */

/* Define to 1 if the X Window System is missing or not being used. */
#define X_DISPLAY_MISSING 1

/* Number of bits in a file offset, on hosts where this is settable. */
/* #undef _FILE_OFFSET_BITS */

/* Define for large files, on AIX-style hosts. */
/* #undef _LARGE_FILES */

/* Define to empty if `const' does not conform to ANSI C. */
/* #undef const */

/* Define to `__inline__' or `__inline' if that's what the C compiler
   calls it, or to nothing if 'inline' is not supported under any name.  */
#ifndef __cplusplus
/* #undef inline */
#endif

/* Define to rpl_malloc if the replacement function should be used. */
/* #undef malloc */

/* Define to `long' if <sys/types.h> does not define. */
/* #undef off_t */

/* Define to `int' if <sys/types.h> does not define. */
/* #undef pid_t */

/* Define to rpl_realloc if the replacement function should be used. */
/* #undef realloc */

/* Define to `unsigned' if <sys/types.h> does not define. */
/* #undef size_t */

/* Define as `fork' if `vfork' does not work. */
/* #undef vfork */



/* Define USE_NAMESPACES if you may access more than one database from the
 * same program
 */
#if defined(USE_INFORMIX) && defined(USE_MYSQL) && defined(HAVE_NAMESPACES)
#define USE_NAMESPACES
#endif


/*
 * Use fftw if we have the library
 */
#if defined(HAVE_LIBFFTW3F) && defined(HAVE_FFTW3_H)
#define USE_FFTWF
#endif

#include "std_fixes.h"

#endif  /* _SAH_CONFIG_H_ */
