<?php
require_once("docutil.php");

page_head("BOINC client simulator");

echo "
The BOINC client simulator simulates the
CPU scheduling and work-fetch policies of the BOINC client.
It uses the same source code as the core client for these policies.
The simulator can be built with 'makefile_sim' on Unix
or the 'sim' project on Windows.

<h2>Usage</h2>
<pre>
sim [--duration X] [--delta X] [--dirs d1 ...]
</pre>
runs the simulator with the given duration and time step.
<p>
When run with --dirs, chdirs into each of the given directories,
and runs a simulation based on the input files there.
Prints summaries of each one separately, and a total summary.

<h2>Output files</h2>
The simulator creates two output files:
<p>
<b>sim_log.txt</b>:
This is the message log
(same as would be generated by the client).
Its contents are controlled by cc_config.xml.
<b>sim_out.html</b>:
When viewed in a web browser, a 'time line' showing what's running when.

<h2>Input files</h2>
The input consists of four files.

<h3>sim_projects.xml</h3>
This describes a set of attached projects.

".html_text("
<projects>
    <project>
        <project_name>P1</project_name>
        <resource_share>100</resource_share>
        <app>
            <latency_bound>1000</latency_bound>
            <fpops_est>1e9</fpops_est>
            <fpops>
                <mean>1e9</mean>
                <stdev>1e5</stdev>
            </fpops>
            <working_set>100000000</working_set>
        </app>
        ...
        <available>
            <frac>.7</frac>
            <lambda>1000</lambda>
        </available>
    </project>
    ...
</projects>
")."

A project has one or more applications.
Each application has a given latency bound and working-set size.
The number of FP ops is a truncated normal distribution
with the given mean and standard deviation.

<p>
The availability of the projects
(i.e. the periods when scheduler RPCs succeed)
is modeled with two parameters:
the duration of available periods are exponentially distributed
with the given mean,
and the unavailable periods are exponentially distributed
achieving the given available fraction.
<h3>sim_host.xml</h3>
This describes the host hardware and availability.
".html_text("
<host>
    <p_fpops>x</p_fpops>
    <m_nbytes>x</m_nbytes>
    <p_ncpus>x</p_ncpus>
    <available>
        <frac>.7</frac>
        <lambda>1000</lambda>
    </available>
    <idle>
        <frac>.7</frac>
        <lambda>1000</lambda>
    </idle>
</host>
")."
The available periods (i.e., when BOINC is running)
and the idle periods (i.e. when there is no user input)
are modeled as above.
<h3>sim_prefs.xml</h3>
Same format as the global_prefs.xml file.
<h3>cc_config.xml</h3>
Same format as the client's cc_config.xml file.
";
page_tail();
?>
