<?php
require_once("docutil.php");
page_head("Web site overview");
echo "
<h2>Customizing the default web site</h2>
<p>
When you create a BOINC project using
<a href=make_project.php>make_project</a>,
a web site is created for you.
This consists of a front page (html/user/index.php),
which links to pages where users can
log in, edit preferences, create profiles, and so on.
<p>
Before your project goes public,
you'll want to change this web site by
adding content specific to your project,
and by giving the web site a graphical identity specific to your project.
Make sure you do a good job;
your web site has a large impact on your project's ability to
<a href=recruit.php>recruit and retain participants</a>.
</ul>

<p>
Some of this customization can be done by editing
the main page (index.php) and the stylesheet (white.css).
Other aspects are changed using a configuration file, described below.

<h2>Web configuration file</h2>
<p>
The file 'html/project/project.inc' serves as a
configuration file for your web site.
It exists in a separate directory (html/project) so that
you can put this directory under CVS
and put all project-specific web files there
(create symbolic links from html/inc and html/user).
<p>
project.inc is generated by <a href=make_project.php>make_project</a>
with default values.
It includes constants:
";
list_start();
list_item("PROJECT", "The name of your project");
list_item("MASTER_URL", "Your project's master URL");
list_item("URL_BASE", "Base URL for web pages (usually same as master URL)");
list_item("STYLESHEET", "Name of stylesheet file");
list_item("COPYRIGHT_HOLDER", "Name of copyright holder");
list_item("SYS_ADMIN_EMAIL", "Users are directed here if they
    have complaints about message-board moderation.
    Also, messages about user-of-the-day running low are sent here.
");
list_item("FORUM_MODERATION_EMAIL_USER_ID",
    "Moderation-related emails (such as user complaints) are sent here.
");
list_item("INVITE_CODES", "regular expression used for
    <a href=account_control.php>controlling account creation</a>.
");
list_item("EMAIL_FROM", "'from' address for emails");
list_item("EMAIL_FROM_NAME", "'from' name for emails");
list_end();

echo "
and functions:
";
list_start();
list_item("project_banner($title)", "prints page header");
list_item("project_banner()", "prints page footer");
list_item("show_profile_heading1(), show_profile_heading2()",
    "text on user profile page");
list_item("show_profile_question1(), show_profile_question2()",
    "text on user profile page");
list_item("project_workunit()",
    "prints project-specific text on workunit page"
);
list_item("project_user_summary()",
    "prints project-specific text on user page"
);
list_item("project_user_page_private()",
    "prints project-specific text on private user page"
);
list_end();
echo "
and variables:
";
list_start();
list_item("USE_PHPMAILER", "Set to true if you use
    <a href=http://phpmailer.sourceforge.net/>PHPMailer</a>.
    In this case you must download PHPMailer and put it
    (i.e. the directory 'phpmailer') in your html/inc directory.
");
list_item("PHPMAILER_HOST",
    "The Host argument to PHPMailer; typically a semicolon-separated list
    of SMTP servers.
");
list_item("PHPMAIL_MAILER",
    "The Mailer argument to PHPMailer; typically 'sendmail', 'mail', or 'smtp'.
");
list_end();
page_tail();
?>
