/***************************************************************************
                          dlghelp.cpp  -  description
                             -------------------
    begin                : Mon Dec 30 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kschenke at users dot sourceforge dot net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA         *
 *   02110-1301, USA                                                       *
 *                                                                         *
 ***************************************************************************/

#include "dlghelp.h"

#include <QTextBrowser>

/***************************************************************************
 *                                                                         *
 *   DlgHelp::DlgHelp()                                                    *
 *                                                                         *
 *   Parameters:                                                           *
 *      QWidget *parent                                                    *
 *      const char *name                                                   *
 *      bool modal                                                         *
 *      WFlags f                                                           *
 *   Return:                                                               *
 *      None                                                               *
 *   Description:                                                          *
 *      Class constructor                                                  *
 *                                                                         *
 ***************************************************************************/

DlgHelp::DlgHelp(const BridgeCfg &cfg, QWidget *parent)
	: QDialog(parent), m_cfg(cfg)
{
	setupUi(this);
	buttonBack->setEnabled(false);
	buttonForward->setEnabled(false);
}

void DlgHelp::on_browserHelp_backwardAvailable(bool available)
{
	buttonBack->setEnabled(available);
}

void DlgHelp::on_browserHelp_forwardAvailable(bool available)
{
	buttonForward->setEnabled(available);
}

void DlgHelp::on_buttonBack_clicked(void)
{
	browserHelp->backward();
}

void DlgHelp::on_buttonForward_clicked(void)
{
	browserHelp->forward();
}

void DlgHelp::on_buttonHome_clicked(void)
{
	browserHelp->home();
}

void DlgHelp::setSource(const QString &source)
{
	browserHelp->setSource(QUrl::fromLocalFile(source));
}
