/***************************************************************************
                  konqueror.h  -  Konqueror Class Definition
                             -------------------
    begin                : Sun Aug 24 2003
    copyright            : (C) 2003 by Ken Schenke
    email                : kschenke at users dot sourceforge dot net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA         *
 *   02110-1301, USA                                                       *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This class implements the Konqueror functionality for read and writing*
 *   bookmarks.                                                            *
 *                                                                         *
 ***************************************************************************/

#ifndef KONQUEROR_H
#define KONQUEROR_H

#include "bknode.h"
#include "browserbk.h"

#include <QTextStream>

class Konqueror : public BrowserBk
{
public:
	Konqueror()	{ }
	~Konqueror()	{ }

	virtual bool    AreBookmarksValid(const QString &bookmarks);
	virtual bool    BrowseForBookmarks(const BridgeCfg &, QString &bookmarks, QWidget *parent=0);
#ifdef Q_WS_X11
	virtual bool	DetectBrowser(const BridgeCfg &, QStringList &paths);
#endif
	virtual void	readBookmarks(const QString &path, BRWSNUM browserOrd) throw(BkException);
	static	void	saveBookmarks(const QString &path, BkFolder &root, BRWSNUM browserOrd)
						throw(BkException);
	static BrowserBk *classFactory(void);

	virtual BkFolder & root(void) { return m_Root; }

private:
	static  void	saveBookmark(const BkBookmark &bkmark, QTextStream &t, int levels, BRWSNUM browserOrd)
						throw(BkException);
	static  void	saveFolder(BkFolder &folder, QTextStream &t, int levels, BRWSNUM browserOrd)
						throw(BkException);

	BkFolder	m_Root;
};

#endif // end of KONQUEROR_H
