// *************************************************************************
//
// Copyleft 2004-2007 Bruno PAGES  .
//
// This file is part of the BOUML Uml Toolkit.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// e-mail : bouml@free.fr
// home   : http://bouml.free.fr
//
// *************************************************************************

#ifdef WIN32
#pragma warning (disable: 4150)
#endif

#include <qsplitter.h> 
#include <qgrid.h> 
#include <qvbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qcombobox.h> 

#include "ArtifactDialog.h"
#include "UmlDesktop.h"
#include "BrowserArtifact.h"
#include "ArtifactData.h"
#include "PackageData.h"
#include "GenerationSettings.h"
#include "BrowserClass.h"
#include "UmlWindow.h"
#include "DialogUtil.h"
#include "KeyValueTable.h"
#include "ClassDialog.h"
#include "ClassData.h"
#include "ListBoxBrowserNode.h"
#include "strutil.h"
#include "UmlPixmap.h"
#include "BodyDialog.h"

QSize ArtifactDialog::previous_size;

ArtifactDialog::ArtifactDialog(ArtifactData * nd)
    : QTabDialog(0, 0, FALSE, WDestructiveClose), data(nd) {
  nd->browser_node->edit_start();
  
  if (nd->browser_node->is_writable())
    setCancelButton();
  else {
    setOkButton(QString::null);
    setCancelButton("Close");
  }

  setCaption("artifact dialog");
  
  init_uml_tab();
  init_cpp_tab();
  init_java_tab();
  init_php_tab();
  init_idl_tab();
  init_assoc_classes_tab();
  init_assoc_artifacts_tab();
  
  // USER : list key - value
  
  QGrid * grid = new QGrid(2, this);
  grid->setMargin(5);
  grid->setSpacing(5);
  
  kvtable = new KeyValuesTable((BrowserArtifact *) data->get_browser_node(),
			       grid, !hasOkButton());
  addTab(grid, "Properties");
  
  //
  
  edStereotypeActivated(data->get_stereotype());

  connect(this, SIGNAL(currentChanged(QWidget *)),
	  this, SLOT(update_tab(QWidget *)));
}

void ArtifactDialog::polish() {
  QTabDialog::polish();
  UmlDesktop::setsize_center(this, previous_size, 0.8, 0.8);
}

ArtifactDialog::~ArtifactDialog() {
  data->browser_node->edit_end();
  previous_size = size();
  
  while (!edits.isEmpty())
    edits.take(0)->close();
}
    
void ArtifactDialog::init_uml_tab() {
  bool visit = !hasOkButton();  
  
  BrowserArtifact * bn = (BrowserArtifact *) data->get_browser_node();
  QVBox * vbox;
  QGrid * grid = new QGrid(2, this);
  
  uml_page = grid;
  grid->setMargin(5);
  grid->setSpacing(5);

  new QLabel("name : ", grid);
  edname = new LineEdit(bn->get_name(), grid);
  edname->setReadOnly(visit);
    
  new QLabel("stereotype : ", grid);
  edstereotype = new QComboBox(TRUE, grid);
  edstereotype->insertItem(toUnicode(data->get_stereotype()));
  if (! visit) {
    edstereotype->insertStringList(BrowserArtifact::default_stereotypes());
    edstereotype->setAutoCompletion(TRUE);
  }
  edstereotype->setCurrentItem(0);
  QSizePolicy sp = edstereotype->sizePolicy();
  sp.setHorData(QSizePolicy::Expanding);
  edstereotype->setSizePolicy(sp);
  if (! visit)
    connect(edstereotype, SIGNAL(activated(const QString &)),
	    this, SLOT(edStereotypeActivated(const QString &)));
    
  vbox = new QVBox(grid);
  new QLabel("description :", vbox);
  if (! visit) {
    connect(new SmallPushButton("Editor", vbox), SIGNAL(clicked()),
	    this, SLOT(edit_description()));
    connect(new SmallPushButton("Default", vbox), SIGNAL(clicked()),
	    this, SLOT(default_description()));
  }
  comment = new MultiLineEdit(grid);
  comment->setReadOnly(visit);
  comment->setText(bn->get_comment());
  QFont font = comment->font();
  if (! hasCodec())
    font.setFamily("Courier");
  font.setFixedPitch(TRUE);
  comment->setFont(font);
  
  addTab(grid, "Uml");
}

void ArtifactDialog::init_cpp_tab() {
  bool visit = !hasOkButton();  
  QHBox * hbox;
  QVBox * vbox;
  QLabel * lbl1;
  QLabel * lbl2;
  QPushButton * edit = 0;
  
  // C++ h

  cpp_h_content_page = new QSplitter(Vertical, this);
  cpp_h_content_page->setOpaqueResize(TRUE);
  
  vbox = new QVBox(cpp_h_content_page); 
  
  hbox = new QHBox(vbox); 
  hbox->setMargin(5);  
  lbl1 = new QLabel("Header file \ndefinition : ", hbox);
  edcpp_h_content = new MultiLineEdit(hbox);
  edcpp_h_content->setText(data->cpp_h);
  QFont font = comment->font();
  if (! hasCodec())
    font.setFamily("Courier");
  font.setFixedPitch(TRUE);
  edcpp_h_content->setFont(font);
  if (visit)
    edcpp_h_content->setReadOnly(TRUE);
  else {
    connect(edcpp_h_content, SIGNAL(textChanged()), this, SLOT(cpp_update_h()));
  
    hbox = new QHBox(vbox); 
    edit = new SmallPushButton("Editor", hbox);
    connect(edit, SIGNAL(clicked()), this, SLOT(cpp_edit_h()));
    connect(new QPushButton("Default definition", hbox), SIGNAL(pressed ()),
	    this, SLOT(cpp_default_h()));
    connect(new QPushButton("Not generated in C++", hbox), SIGNAL(pressed ()),
	    this, SLOT(cpp_unmapped_h()));
  }
  
  hbox = new QHBox(cpp_h_content_page, "result"); 
  hbox->setMargin(5);  
  lbl2 = new QLabel("Result after\nsubstitution : ", hbox);
  showcpp_h_content = new MultiLineEdit(hbox);
  showcpp_h_content->setReadOnly(TRUE);
  showcpp_h_content->setFont(font);

  if (visit)
    same_width(lbl1, lbl2);
  else
    same_width(lbl1, lbl2, edit);
  
  addTab(cpp_h_content_page, "C++ header");
  
  if (!GenerationSettings::cpp_get_default_defs())
    removePage(cpp_h_content_page);
  
  // C++ source

  cpp_src_content_page = new QSplitter(Vertical, this);
  cpp_src_content_page->setOpaqueResize(TRUE);
  
  vbox = new QVBox(cpp_src_content_page); 
  
  hbox = new QHBox(vbox); 
  hbox->setMargin(5);  
  lbl1 = new QLabel("Source file \ndefinition : ", hbox);
  edcpp_src_content = new MultiLineEdit(hbox);
  edcpp_src_content->setText(data->cpp_src);
  edcpp_src_content->setFont(font);
  if (visit)
    edcpp_src_content->setReadOnly(TRUE);
  else {
    connect(edcpp_src_content, SIGNAL(textChanged()), this, SLOT(cpp_update_src()));

    hbox = new QHBox(vbox); 
    edit = new SmallPushButton("Editor", hbox);
    connect(edit, SIGNAL(clicked()), this, SLOT(cpp_edit_src()));
    connect(new QPushButton("Default definition", hbox), SIGNAL(pressed ()),
	    this, SLOT(cpp_default_src()));
    connect(new QPushButton("Not generated in C++", hbox), SIGNAL(pressed ()),
	    this, SLOT(cpp_unmapped_src()));
  }

  hbox = new QHBox(cpp_src_content_page, "result"); 
  hbox->setMargin(5);  
  lbl2 = new QLabel("Result after\nsubstitution : ", hbox);
  showcpp_src_content = new MultiLineEdit(hbox);
  showcpp_src_content->setReadOnly(TRUE);
  showcpp_src_content->setFont(font);
  
  if (visit)
    same_width(lbl1, lbl2);
  else
    same_width(lbl1, lbl2, edit);
  
  addTab(cpp_src_content_page, "C++ source");
  
  if (!GenerationSettings::cpp_get_default_defs())
    removePage(cpp_src_content_page);
}

void ArtifactDialog::init_java_tab() {
  bool visit = !hasOkButton();  
  QHBox * hbox;
  QVBox * vbox;
  QLabel * lbl1;
  QLabel * lbl2;
  QPushButton * edit = 0;
  
  java_content_page = new QSplitter(Vertical, this);
  java_content_page->setOpaqueResize(TRUE);
  
  vbox = new QVBox(java_content_page); 
  
  hbox = new QHBox(vbox); 
  hbox->setMargin(5);  
  lbl1 = new QLabel("File \ndefinition : ", hbox);
  edjava_content = new MultiLineEdit(hbox);
  edjava_content->setText(data->java_src);
  QFont font = comment->font();
  if (! hasCodec())
    font.setFamily("Courier");
  font.setFixedPitch(TRUE);
  edjava_content->setFont(font);
  if (visit)
    edjava_content->setReadOnly(TRUE);
  else {
    connect(edjava_content, SIGNAL(textChanged()), this, SLOT(java_update_src()));

    hbox = new QHBox(vbox); 
    edit = new SmallPushButton("Editor", hbox);
    connect(edit, SIGNAL(clicked()), this, SLOT(java_edit()));
    connect(new QPushButton("Default definition", hbox), SIGNAL(pressed ()),
	    this, SLOT(java_default_src()));
    connect(new QPushButton("Not generated in Java", hbox), SIGNAL(pressed ()),
	    this, SLOT(java_unmapped_src()));
  }

  hbox = new QHBox(java_content_page, "result"); 
  hbox->setMargin(5);  
  lbl2 = new QLabel("Result after\nsubstitution : ", hbox);
  showjava_content = new MultiLineEdit(hbox);
  showjava_content->setReadOnly(TRUE);
  showjava_content->setFont(font);
  
  if (visit)
    same_width(lbl1, lbl2);
  else
    same_width(lbl1, lbl2, edit);
  
  addTab(java_content_page, "Java source");
  
  if (!GenerationSettings::java_get_default_defs())
    removePage(java_content_page);
}

void ArtifactDialog::init_php_tab() {
  bool visit = !hasOkButton();  
  QHBox * hbox;
  QVBox * vbox;
  QLabel * lbl1;
  QLabel * lbl2;
  QPushButton * edit = 0;
  
  php_content_page = new QSplitter(Vertical, this);
  php_content_page->setOpaqueResize(TRUE);
  
  vbox = new QVBox(php_content_page); 
  
  hbox = new QHBox(vbox); 
  hbox->setMargin(5);  
  lbl1 = new QLabel("File \ndefinition : ", hbox);
  edphp_content = new MultiLineEdit(hbox);
  edphp_content->setText(data->php_src);
  QFont font = comment->font();
  if (! hasCodec())
    font.setFamily("Courier");
  font.setFixedPitch(TRUE);
  edphp_content->setFont(font);
  if (visit)
    edphp_content->setReadOnly(TRUE);
  else {
    connect(edphp_content, SIGNAL(textChanged()), this, SLOT(php_update_src()));

    hbox = new QHBox(vbox); 
    edit = new SmallPushButton("Editor", hbox);
    connect(edit, SIGNAL(clicked()), this, SLOT(php_edit()));
    connect(new QPushButton("Default definition", hbox), SIGNAL(pressed ()),
	    this, SLOT(php_default_src()));
    connect(new QPushButton("Not generated in Php", hbox), SIGNAL(pressed ()),
	    this, SLOT(php_unmapped_src()));
  }

  hbox = new QHBox(php_content_page, "result"); 
  hbox->setMargin(5);  
  lbl2 = new QLabel("Result after\nsubstitution : ", hbox);
  showphp_content = new MultiLineEdit(hbox);
  showphp_content->setReadOnly(TRUE);
  showphp_content->setFont(font);
  
  if (visit)
    same_width(lbl1, lbl2);
  else
    same_width(lbl1, lbl2, edit);
  
  addTab(php_content_page, "Php source");
  
  if (!GenerationSettings::php_get_default_defs())
    removePage(php_content_page);
}

void ArtifactDialog::init_idl_tab() {
  bool visit = !hasOkButton();  
  QHBox * hbox;
  QVBox * vbox;
  QLabel * lbl1;
  QLabel * lbl2;
  QPushButton * edit = 0;
  
  idl_content_page = new QSplitter(Vertical, this);
  idl_content_page->setOpaqueResize(TRUE);
  
  vbox = new QVBox(idl_content_page); 
  
  hbox = new QHBox(vbox); 
  hbox->setMargin(5);  
  lbl1 = new QLabel("File \ndefinition : ", hbox);
  edidl_content = new MultiLineEdit(hbox);
  edidl_content->setText(data->idl_src);
  QFont font = comment->font();
  if (! hasCodec())
    font.setFamily("Courier");
  font.setFixedPitch(TRUE);
  edidl_content->setFont(font);
  if (visit)
    edidl_content->setReadOnly(TRUE);
  else {
    connect(edidl_content, SIGNAL(textChanged()), this, SLOT(idl_update_src()));
    
    hbox = new QHBox(vbox); 
    edit = new SmallPushButton("Editor", hbox);
    connect(edit, SIGNAL(clicked()), this, SLOT(idl_edit()));
    connect(new QPushButton("Default definition", hbox), SIGNAL(pressed ()),
	    this, SLOT(idl_default_src()));
    connect(new QPushButton("Not generated in Idl", hbox), SIGNAL(pressed ()),
	    this, SLOT(idl_unmapped_src()));
  }
  
  hbox = new QHBox(idl_content_page, "result"); 
  hbox->setMargin(5);  
  lbl2 = new QLabel("Result after\nsubstitution : ", hbox);
  showidl_content = new MultiLineEdit(hbox);
  showidl_content->setReadOnly(TRUE);
  showidl_content->setFont(font);
  
  if (visit)
    same_width(lbl1, lbl2);
  else
    same_width(lbl1, lbl2, edit);
  
  addTab(idl_content_page, "Idl source");
  
  if (!GenerationSettings::idl_get_default_defs())
    removePage(idl_content_page);
}

void ArtifactDialog::init_assoc_classes_tab() {
  bool visit = !hasOkButton();  
  QHBox * hbox;
  QVBox * vbox;  
  QPushButton * button;
  BrowserArtifact * bn = (BrowserArtifact *) data->get_browser_node();
  const QValueList<BrowserClass *> & l = bn->get_associated_classes();
  QValueList<BrowserClass *>::ConstIterator it;
  QValueList<BrowserClass *>::ConstIterator end = l.end();
  
  cl_assoc_page = new QVBox(this);
  
  if (!visit) {
    hbox = new QHBox(cl_assoc_page);
    vbox = new QVBox(hbox);
    vbox->setMargin(5);
    (new QLabel("Classes without artifact", vbox))->setAlignment(AlignCenter);
    lb_cl_available = new QListBox(vbox);
    lb_cl_available->setSelectionMode(QListBox::Multi);
    
    QPtrDict<BrowserNode> d(97);
    
    for (it = l.begin(); it != end; ++it)
      d.insert(*it, *it);
    
    BrowserNode * cl;
    BrowserNodeList classes;
    
    BrowserClass::instances(classes, 0, TRUE);
    
    for (cl = classes.first(); cl != 0; cl = classes.next())
      if ((((BrowserClass *) cl)->get_associated_artifact() == 0) &&
	  (d.find(cl) == 0))
	lb_cl_available->insertItem(new ListBoxBrowserNode(cl, cl->full_name(TRUE)));
    
    lb_cl_available->sort();
    
    vbox = new QVBox(hbox);
    vbox->setMargin(5);
    (new QLabel("", vbox))->setScaledContents(TRUE);
    button = new QPushButton(vbox);
    button->setPixmap(*rightPixmap);
    connect(button, SIGNAL(clicked()), this, SLOT(associate_cls()));
    (new QLabel("", vbox))->setScaledContents(TRUE);
    button = new QPushButton(vbox);
    button->setPixmap(*leftPixmap);
    connect(button, SIGNAL(clicked()), this, SLOT(unassociate_cls()));
    (new QLabel("", vbox))->setScaledContents(TRUE);
    vbox = new QVBox(hbox);
  }
  else
    vbox = cl_assoc_page;
  
  vbox->setMargin(5);
  (new QLabel("Associated classes", vbox))->setAlignment(AlignCenter);
  lb_cl_associated = new QListBox(vbox);
  lb_cl_associated->setSelectionMode((visit) ? QListBox::NoSelection
					     : QListBox::Multi);
  
  n_cpp = n_java = n_php = n_idl = 0;
  
  for (it = l.begin(); it != end; ++it) {
    if (!(*it)->deletedp() && !(*it)->nestedp()) {
      lb_cl_associated->insertItem(new ListBoxBrowserNode(*it, (*it)->full_name(TRUE)));
      
      ClassData * c = (ClassData *) (*it)->get_data();
      
      if (c->get_cppdecl()[0])
	n_cpp += 1;
      if (c->get_javadecl()[0])
	n_java += 1;
      if (c->get_phpdecl()[0])
	n_php += 1;
      if (c->get_idldecl()[0])
	n_idl += 1;
    }
  }
  
  if (!visit) {
    hbox = new QHBox(vbox); 
    hbox->setMargin(5);
    (new QLabel("", hbox))->setScaledContents(TRUE);
    button = new QPushButton("go up", hbox);
    connect(button, SIGNAL(clicked()), this, SLOT(move_cls_up()));
    (new QLabel("", hbox))->setScaledContents(TRUE);
    button = new QPushButton("go down", hbox);
    connect(button, SIGNAL(clicked()), this, SLOT(move_cls_down()));
    (new QLabel("", hbox))->setScaledContents(TRUE);
  }
  addTab(cl_assoc_page, "Associated classes");
}

void ArtifactDialog::init_assoc_artifacts_tab() {
  bool visit = !hasOkButton();  
  QHBox * hbox;
  QVBox * vbox;  
  QPushButton * button;
  
  art_assoc_page = new QVBox(this);
  
  if (!visit) {
    hbox = new QHBox(art_assoc_page); 
    hbox->setMargin(5);
    new QLabel("Stereotype filtering  ", hbox);
    stereotypefilter = new QComboBox(TRUE, hbox);
    stereotypefilter->setAutoCompletion(TRUE);
    stereotypefilter->insertItem("");
    stereotypefilter->insertStringList(BrowserArtifact::default_stereotypes());
    stereotypefilter->setCurrentItem(0);
    QSizePolicy sp = stereotypefilter->sizePolicy();
    sp.setHorData(QSizePolicy::Expanding);
    stereotypefilter->setSizePolicy(sp);
    connect(stereotypefilter, SIGNAL(activated(const QString &)),
	    this, SLOT(stereotypeFilterActivated(const QString &)));
    
    hbox = new QHBox(art_assoc_page);
    vbox = new QVBox(hbox);
    vbox->setMargin(5);
    (new QLabel("Unassociated artifacts", vbox))->setAlignment(AlignCenter);
    lb_art_available = new QListBox(vbox);
    lb_art_available->setSelectionMode(QListBox::Multi);
    
    vbox = new QVBox(hbox);
    vbox->setMargin(5);
    (new QLabel("", vbox))->setScaledContents(TRUE);
    button = new QPushButton(vbox);
    button->setPixmap(*rightPixmap);
    connect(button, SIGNAL(clicked()), this, SLOT(associate_arts()));
    (new QLabel("", vbox))->setScaledContents(TRUE);
    button = new QPushButton(vbox);
    button->setPixmap(*leftPixmap);
    connect(button, SIGNAL(clicked()), this, SLOT(unassociate_arts()));
    (new QLabel("", vbox))->setScaledContents(TRUE);
    vbox = new QVBox(hbox);
  }
  else
    vbox = art_assoc_page;
  
  vbox->setMargin(5);
  (new QLabel("Associated artifacts", vbox))->setAlignment(AlignCenter);
  lb_art_associated = new QListBox(vbox);
  lb_art_associated->setSelectionMode((visit) ? QListBox::NoSelection
					       : QListBox::Multi);
  lb_art_initialized = FALSE;

  addTab(art_assoc_page, "Associated artifacts");
}

void ArtifactDialog::default_description() {
  comment->setText(GenerationSettings::default_artifact_description());
}

void ArtifactDialog::edit_description() {
  edit(comment->text(), edname->text().stripWhiteSpace() + "_description",
       data, TxtEdit, this, (post_edit) post_edit_description, edits);
}

void ArtifactDialog::post_edit_description(ArtifactDialog * d, QString s) {
  d->comment->setText(s);
}

void ArtifactDialog::edStereotypeActivated(const QString & ste) {
  bool a_source = (ste.stripWhiteSpace() == "source");
  bool a_text = (ste.stripWhiteSpace() == "text");
    
  setTabEnabled(cpp_h_content_page, a_source && !a_text);
  setTabEnabled(cpp_src_content_page, a_source || a_text);
  setTabEnabled(java_content_page, a_source || a_text);
  setTabEnabled(php_content_page, a_source || a_text);
  setTabEnabled(idl_content_page, a_source || a_text);
  setTabEnabled(cl_assoc_page, a_source && !a_text);
  setTabEnabled(art_assoc_page, !a_source && !a_text);
  
  if (!a_source && !a_text) {
    if (!lb_art_initialized) {
      lb_art_initialized = TRUE;
      if (data->associated != 0)
	art_associated = *(data->associated);
      stereotypeFilterActivated(QString::null);
    }
  }
  else if (lb_cl_associated->count() != 0) {
    if (n_cpp == 0) {
      setTabEnabled(cpp_h_content_page, FALSE);      
      setTabEnabled(cpp_src_content_page, FALSE);
    }
    
    if (n_java == 0)
      setTabEnabled(java_content_page, FALSE);
    
    if (n_php == 0)
      setTabEnabled(php_content_page, FALSE);
    
    if (n_idl == 0)
      setTabEnabled(idl_content_page, FALSE);
  }
}

void ArtifactDialog::update_tab(QWidget * w) {
  bool visit = !hasOkButton();  

  if (w == uml_page) {
    if (! visit)
      edname->setFocus();
  }
  else if (w == cpp_h_content_page) {
    cpp_update_h();
    if (! visit)
      edcpp_h_content->setFocus();
  }
  else if (w == cpp_src_content_page) {
    cpp_update_src();
    if (! visit)
      edcpp_src_content->setFocus();
  }
  else if (w == java_content_page) {
    java_update_src();
    if (! visit)
      edjava_content->setFocus();
  }
  else if (w == php_content_page) {
    php_update_src();
    if (! visit)
      edphp_content->setFocus();
  }
  else if (w == idl_content_page) {
    idl_update_src();
    if (! visit)
      edidl_content->setFocus();
  }
}


void ArtifactDialog::cpp_edit_h() {
  edit(edcpp_h_content->text(),
       edname->text().stripWhiteSpace() + "_header", data,
       CppEdit, this, (post_edit) post_cpp_edit_h, edits);
}

void ArtifactDialog::post_cpp_edit_h(ArtifactDialog * d, QString s)
{
  d->edcpp_h_content->setText(s);
}

void ArtifactDialog::cpp_edit_src() {
  edit(edcpp_src_content->text(),
       edname->text().stripWhiteSpace() + "_source", data,
       (edstereotype->currentText().stripWhiteSpace() == "text") ? TxtEdit : CppEdit,
       this, (post_edit) post_cpp_edit_src, edits);
}

void ArtifactDialog::post_cpp_edit_src(ArtifactDialog * d, QString s)
{
  d->edcpp_src_content->setText(s);
}

void ArtifactDialog::java_edit() {
  edit(edjava_content->text(),
       edname->text().stripWhiteSpace() + "_source", data,
       (edstereotype->currentText().stripWhiteSpace() == "text") ? TxtEdit : JavaEdit,
       this, (post_edit) post_java_edit, edits);
}

void ArtifactDialog::post_java_edit(ArtifactDialog * d, QString s)
{
  d->edjava_content->setText(s);
}

void ArtifactDialog::php_edit() {
  edit(edphp_content->text(),
       edname->text().stripWhiteSpace() + "_source", data,
       (edstereotype->currentText().stripWhiteSpace() == "text") ? TxtEdit : PhpEdit,
       this, (post_edit) post_php_edit, edits);
}

void ArtifactDialog::post_php_edit(ArtifactDialog * d, QString s)
{
  d->edphp_content->setText(s);
}

void ArtifactDialog::idl_edit() {
  edit(edidl_content->text(),
       edname->text().stripWhiteSpace() + "_source",
       data, TxtEdit, this, (post_edit) post_idl_edit, edits);
}

void ArtifactDialog::post_idl_edit(ArtifactDialog * d, QString s)
{
  d->edidl_content->setText(s);
}

void ArtifactDialog::cpp_default_h() {
  edcpp_h_content->setText((n_cpp != 0)
			   ? GenerationSettings::cpp_default_header_content()
			   : "");
  cpp_update_h();
}

void ArtifactDialog::cpp_default_src() {
  edcpp_src_content->setText(((n_cpp != 0) &&
			      (edstereotype->currentText().stripWhiteSpace() != "text"))
			     ? GenerationSettings::cpp_default_source_content()
			     : "");
  cpp_update_src();
}

void ArtifactDialog::java_default_src() {
  edjava_content->setText(((n_java != 0) &&
			   (edstereotype->currentText().stripWhiteSpace() != "text"))
			  ? GenerationSettings::java_default_source_content()
			  : "");
  java_update_src();
}

void ArtifactDialog::php_default_src() {
  edphp_content->setText(((n_php != 0) &&
			  (edstereotype->currentText().stripWhiteSpace() != "text"))
			 ? GenerationSettings::php_default_source_content()
			 : "");
  php_update_src();
}

void ArtifactDialog::idl_default_src() {
  edidl_content->setText(((n_idl != 0) &&
			  (edstereotype->currentText().stripWhiteSpace() != "text"))
			 ? GenerationSettings::idl_default_source_content()
			 : "");
  idl_update_src();
}

void ArtifactDialog::cpp_unmapped_h() {
  edcpp_h_content->setText(QString::null);
  cpp_update_h();
}

void ArtifactDialog::cpp_unmapped_src() {
  edcpp_src_content->setText(QString::null);
  cpp_update_src();
}

void ArtifactDialog::java_unmapped_src() {
  edjava_content->setText(QString::null);
  java_update_src();
}

void ArtifactDialog::php_unmapped_src() {
  edphp_content->setText(QString::null);
  php_update_src();
}

void ArtifactDialog::idl_unmapped_src() {
  edidl_content->setText(QString::null);
  idl_update_src();
}

static void hide_result(QSplitter * spl)
{
  QHBox * vb = (QHBox *) spl->child("result");
  
  if (vb->isVisible()) {
    vb->hide();
    
    QValueList<int> sz = spl->sizes();
    
    sz[0] = sz[0] + sz[1];
    sz[1] = 0;
    spl->setSizes(sz);
  }
}

static void show_result(QSplitter * spl)
{
  QHBox * vb = (QHBox *) spl->child("result");

  if (vb->isHidden()) {
    QValueList<int> sz = spl->sizes();
    
    sz[1] = sz[0] = sz[0]/2;
    spl->setSizes(sz);
    
    vb->show();      
  }
}

void ArtifactDialog::compute_cpp_namespace(QString & nasp,
					   QString & nasp_start,
					   QString & nasp_end) {
  nasp = (const char *)
    ((PackageData *) 
     ((BrowserNode *) data->browser_node->parent()->parent())->get_data())
      ->get_cpp_namespace();
    
  if (! nasp.isEmpty()) {
    int index = 0;
    int index2;
    
    while ((index2 = nasp.find(':', index)) != -1) {
      nasp_start += QString("namespace ") +
	nasp.mid(index, index2 - index) + " {\n\n";
      nasp_end += "\n}\n";
      nasp.replace(index2, 2, "_");
      index = index2 + 1;
    }
    
    nasp_start += QString("namespace ") + nasp.mid(index) + " {\n\n";
    nasp_end += "\n}\n";
  }
}

QString ArtifactDialog::compute_java_package() {
  const QString pack =  (const char *)
    ((PackageData *) 
     ((BrowserNode *) data->browser_node->parent()->parent())->get_data())
      ->get_java_package();
    
  return (pack.isEmpty())
    ? pack
    : QString("package ") + pack + ";\n";
}

void ArtifactDialog::compute_idl_module(QString & mod,
					QString & mod_start,
					QString & mod_end) {
  mod =  (const char *)
    ((PackageData *) 
     ((BrowserNode *) data->browser_node->parent()->parent())->get_data())
      ->get_idl_module();
    
  if (! mod.isEmpty()) {
    int index = 0;
    int index2;
    
    while ((index2 = mod.find(':', index)) != -1) {
      mod_start += QString("module ") +
	mod.mid(index, index2 - index) + " {\n\n";
      mod_end += "\n};\n";
      mod.replace(index2, 2, "_");
      index = index2 + 1;
    }
    
    mod_start += QString("module ") + mod.mid(index) + " {\n\n";
    mod_end += "\n};\n";
  }
}

void ArtifactDialog::cpp_update_h() {
  if (lb_cl_associated->count() == 0)
    hide_result(cpp_h_content_page);
  else {
    show_result(cpp_h_content_page);
    
    QString def = edcpp_h_content->text();  
    const char * p = def;
    const char * pp = 0;
    QString s;
    QString nasp;
    QString nasp_start;
    QString nasp_end;
    
    compute_cpp_namespace(nasp, nasp_start, nasp_end);
    
    bool all_incl = (def.find("${all_includes}") != -1);
    
    for (;;) {
      if (*p == 0) {
	if (pp == 0)
	  break;
	
	// comment management done
	p = pp;
	pp = 0;
	if (*p == 0)
	  break;
      }
      
      
      if (*p == '@')
	manage_alias(data->browser_node, p, s, kvtable);
      else if (*p != '$')
	s += *p++;
      else if (!strncmp(p, "${comment}", 10))
	manage_comment(comment->text(), p, pp,
		       GenerationSettings::cpp_javadoc_style());
      else if (!strncmp(p, "${description}", 14))
	manage_description(comment->text(), p, pp);
      else if (!strncmp(p, "${name}", 7)) {
	p += 7;
	s += edname->text().stripWhiteSpace();
      }
      else if (!strncmp(p, "${Name}", 7)) {
	p += 7;
	s += capitalize(edname->text().stripWhiteSpace());
      }
      else if (!strncmp(p, "${NAME}", 7)) {
	p += 7;
	s += edname->text().stripWhiteSpace().upper();
      }
      else if (!strncmp(p, "${namespace}", 12)) {
	p += 12;
	s += nasp;
      }
      else if (!strncmp(p, "${NAMESPACE}", 12)) {
	p += 12;
	s += nasp.upper();
      }
      else if (!strncmp(p, "${includes}", 11)) {
	p += 11;
	s += (all_incl)
	  ? "ERROR : ${includes} exclusive with ${all_includes}\n"
	  : "...#include \"a_needed_file.h\"   // produced by the C++ generator\n";
      }
      else if (!strncmp(p, "${all_includes}", 15)) {
	p += 15;
	s += "...#include \"a_needed_file.h\"   // produced by the C++ generator\n";
      }
      else if (!strncmp(p, "${declarations}", 15)) {
	p += 15;
	s += (all_incl)
	  ? "WARNING : ${declarations} is useless because of ${all_includes}\n"
	  : "...class a_referenced_class;    // produced by the C++ generator\n";
      }
      else if (!strncmp(p, "${namespace_start}", 18)) {
	p += 18;
	s += nasp_start;
      }
      else if (!strncmp(p, "${namespace_end}", 16)) {
	p += 16;
	s += nasp_end;
      }
      else if (!strncmp(p, "${definition}", 13)) {
	p += 13;
	if (*p == '\n')
	  p += 1;

	static QStringList nodes;	// must be static for FormalParamsTable
	QStringList node_names;
	unsigned n = lb_cl_associated->count();

	for (unsigned i = 0; i != n; i += 1) {
	  BrowserNode * bn =
	    ((ListBoxBrowserNode *) lb_cl_associated->item(i))->browser_node;
	  ClassData * c = (ClassData *) bn->get_data();
    
	  if (c->get_cppdecl()[0]) {
	    FormalParamsTable * f = formals[(BrowserClass *) bn];
	    
	    if (f == 0) {
	      f = new FormalParamsTable(c, currentPage(), nodes, TRUE);
	      f->hide();
	      formals.insert((BrowserClass *) bn, f);
	    }
	    
	    ActualParamsTable * a;
	    
	    if (c->get_n_actualparams() == 0)
	      a = 0;
	    else if ((a = actuals[(BrowserClass *) bn]) == 0) {
	      a = new ActualParamsTable(c, currentPage(), nodes, TRUE);
	      a->hide();
	      actuals.insert((BrowserClass *) bn, a);
	    }
	
	    const AType & t = c->get_base_type();
	    BrowserNodeList nds;
	  
	    ClassDialog::cpp_generate_decl(s, c, c->get_cppdecl(),
					   true_name(bn->get_name(),
						     c->get_cppdecl()),
					   c->get_stereotype(),
					   (t.type != 0) ? t.type->full_name(TRUE)
							 : QString((const char *) t.explicit_type),
					   bn->get_comment(), a, f,
					   nds, node_names, 0);
	    s += '\n';
	  }
	}
      }
      else
	// strange
	s += *p++;
    }
  
    showcpp_h_content->setText(s);
  }
}

void ArtifactDialog::cpp_update_src() {
  if (lb_cl_associated->count() == 0)
    hide_result(cpp_src_content_page);
  else {
    show_result(cpp_src_content_page);
    
    QString def = edcpp_src_content->text();
    const char * p = def;
    const char * pp = 0;
    QString s;
    QString nasp;
    QString nasp_start;
    QString nasp_end;
    
    compute_cpp_namespace(nasp, nasp_start, nasp_end);
    
    for (;;) {
      if (*p == 0) {
	if (pp == 0)
	  break;
	
	// comment management done
	p = pp;
	pp = 0;
	if (*p == 0)
	  break;
      }
      
      if (*p == '@')
	manage_alias(data->browser_node, p, s, kvtable);
      else if (*p != '$')
	s += *p++;
      else if (!strncmp(p, "${comment}", 10))
	manage_comment(comment->text(), p, pp,
		       GenerationSettings::cpp_javadoc_style());
      else if (!strncmp(p, "${description}", 14))
	manage_description(comment->text(), p, pp);
      else if (!strncmp(p, "${includes}", 11)) {
	p += 11;
	s += "...#include \"a_needed_file.h\"   // produced by the C++ generator\n";
      }
      else if (!strncmp(p, "${name}", 7)) {
	p += 7;
	s += edname->text().stripWhiteSpace();
      }
      else if (!strncmp(p, "${Name}", 7)) {
	p += 7;
	s += capitalize(edname->text().stripWhiteSpace());
      }
      else if (!strncmp(p, "${NAME}", 7)) {
	p += 7;
	s += edname->text().stripWhiteSpace().upper();
      }
      else if (!strncmp(p, "${namespace}", 12)) {
	p += 12;
	s += nasp;
      }
      else if (!strncmp(p, "${NAMESPACE}", 12)) {
	p += 12;
	s += nasp.upper();
      }
      else if (!strncmp(p, "${namespace_start}", 18)) {
	p += 18;
	s += nasp_start;
      }
      else if (!strncmp(p, "${members}", 10)) {
	p += 10;
	if (*p == '\n')
	  p += 1;
	
	unsigned n = lb_cl_associated->count();

	for (unsigned i = 0; i != n; i += 1)
	  ClassDialog::cpp_generate_members_def(((ListBoxBrowserNode *) lb_cl_associated->item(i))->browser_node,
						s);
      }
      else if (!strncmp(p, "${namespace_end}", 16)) {
	p += 16;
	s += nasp_end;
      }
      else
	// strange
	s += *p++;
    }
    
    showcpp_src_content->setText(s);
  }
}

void ArtifactDialog::java_update_src() {
  if (lb_cl_associated->count() == 0)
    hide_result(java_content_page);
  else {
    show_result(java_content_page);
    
    QString def = edjava_content->text();  
    const char * p = def;
    const char * pp = 0;
    QString s;
    
    for (;;) {
      if (*p == 0) {
	if (pp == 0)
	  break;
	
	// comment management done
	p = pp;
	pp = 0;
	if (*p == 0)
	  break;
      }
       
      if (*p == '@')
	manage_alias(data->browser_node, p, s, kvtable);
      else if (*p != '$')
	s += *p++;
      else if (!strncmp(p, "${comment}", 10))
	manage_comment(comment->text(), p, pp,
		       GenerationSettings::java_javadoc_style());
      else if (!strncmp(p, "${description}", 14))
	manage_description(comment->text(), p, pp);
      else if (!strncmp(p, "${name}", 7)) {
	p += 7;
	s += edname->text().stripWhiteSpace();
      }
      else if (!strncmp(p, "${imports}", 10)) {
	p += 10;
	s += "...import a_needed_package   // produced by the Java generator\n";
      }
      else if (!strncmp(p, "${Name}", 7)) {
	p += 7;
	s += capitalize(edname->text().stripWhiteSpace());
      }
      else if (!strncmp(p, "${NAME}", 7)) {
	p += 7;
	s += edname->text().stripWhiteSpace().upper();
      }
      else if (!strncmp(p, "${package}", 10)) {
	p += 10;
	s += compute_java_package();
      }
      else if (!strncmp(p, "${definition}", 13)) {
	p += 13;
	if (*p == '\n')
	  p += 1;
	
	static QStringList nodes;	// must be static for FormalParamsTable
	QStringList node_names;
	unsigned n = lb_cl_associated->count();

	for (unsigned i = 0; i != n; i += 1) {
	  BrowserNode * bn =
	    ((ListBoxBrowserNode *) lb_cl_associated->item(i))->browser_node;
	  ClassData * c = (ClassData *) bn->get_data();
	  FormalParamsTable * f = formals[(BrowserClass *) bn];
	  
	  if (f == 0) {
	    f = new FormalParamsTable(c, currentPage(), nodes, TRUE);
	    f->hide();
	    formals.insert((BrowserClass *) bn, f);
	  }
	    
	  ActualParamsTable * a;
	  
	  if (c->get_n_actualparams() == 0)
	    a = 0;
	  else if ((a = actuals[(BrowserClass *) bn]) == 0) {
	    a = new ActualParamsTable(c, currentPage(), nodes, TRUE);
	    a->hide();
	    actuals.insert((BrowserClass *) bn, a);
	  }
	  
	  BrowserNodeList nds;
	  
	  ClassDialog::java_generate_decl(s, c, c->get_javadecl(), "", bn->get_name(),
					  c->get_stereotype(), bn->get_comment(),
					  c->get_uml_visibility(), c->java_is_final(),
					  c->get_is_abstract(), a, f, nds, node_names, 0);
	  s += '\n';
	}
      }
      else
	// strange
	s += *p++;
    }
    
    showjava_content->setText(s);
  }
}

void ArtifactDialog::php_update_src() {
  if (lb_cl_associated->count() == 0)
    hide_result(php_content_page);
  else {
    show_result(php_content_page);
    
    QString def = edphp_content->text();  
    const char * p = def;
    const char * pp = 0;
    QString s;
    
    for (;;) {
      if (*p == 0) {
	if (pp == 0)
	  break;
	
	// comment management done
	p = pp;
	pp = 0;
	if (*p == 0)
	  break;
      }
       
      if (*p == '@')
	manage_alias(data->browser_node, p, s, kvtable);
      else if (*p != '$')
	s += *p++;
      else if (!strncmp(p, "${comment}", 10))
	manage_comment(comment->text(), p, pp, FALSE);
      else if (!strncmp(p, "${description}", 14))
	manage_description(comment->text(), p, pp);
      else if (!strncmp(p, "${name}", 7)) {
	p += 7;
	s += edname->text().stripWhiteSpace();
      }
      else if (!strncmp(p, "${Name}", 7)) {
	p += 7;
	s += capitalize(edname->text().stripWhiteSpace());
      }
      else if (!strncmp(p, "${NAME}", 7)) {
	p += 7;
	s += edname->text().stripWhiteSpace().upper();
      }
      else if (!strncmp(p, "${definition}", 13)) {
	p += 13;
	if (*p == '\n')
	  p += 1;
	
	static QStringList nodes;	// must be static for FormalParamsTable
	QStringList node_names;
	unsigned n = lb_cl_associated->count();

	for (unsigned i = 0; i != n; i += 1) {
	  BrowserNode * bn =
	    ((ListBoxBrowserNode *) lb_cl_associated->item(i))->browser_node;
	  ClassData * c = (ClassData *) bn->get_data();
	  
	  ClassDialog::php_generate_decl(s, c, c->get_phpdecl(), bn->get_name(),
					 c->get_stereotype(), bn->get_comment(),
					 c->get_uml_visibility(), c->php_is_final(),
					 c->get_is_abstract(), 0);
	  s += '\n';
	}
      }
      else
	s += *p++;
    }
    
    showphp_content->setText(s);
  }
}

void ArtifactDialog::idl_update_src() {
  if (lb_cl_associated->count() == 0)
    hide_result(idl_content_page);
  else {
    show_result(idl_content_page);
    
    QString def = edidl_content->text();  
    const char * p = def;
    const char * pp = 0;
    QString s;
    QString mod;
    QString mod_start;
    QString mod_end;
    
    compute_idl_module(mod, mod_start, mod_end);
    
    for (;;) {
      if (*p == 0) {
	if (pp == 0)
	  break;
	
	// comment management done
	p = pp;
	pp = 0;	
	if (*p == 0)
	  break;
      }
      
      
      if (*p == '@')
	manage_alias(data->browser_node, p, s, kvtable);
      else if (*p != '$')
	s += *p++;
      else if (!strncmp(p, "${comment}", 10))
	manage_comment(comment->text(), p, pp, FALSE);
      else if (!strncmp(p, "${description}", 14))
	manage_description(comment->text(), p, pp);
      else if (!strncmp(p, "${name}", 7)) {
	p += 7;
	s += edname->text().stripWhiteSpace();
      }
      else if (!strncmp(p, "${Name}", 7)) {
	p += 7;
	s += capitalize(edname->text().stripWhiteSpace());
      }
      else if (!strncmp(p, "${NAME}", 7)) {
	p += 7;
	s += edname->text().stripWhiteSpace().upper();
      }
      else if (!strncmp(p, "${module}", 9)) {
	p += 9;
	s += mod;
      }
      else if (!strncmp(p, "${MODULE}", 9)) {
	p += 9;
	s += mod.upper();
      }
      else if (!strncmp(p, "${includes}", 11)) {
	p += 11;
	s += "...#include \"a_needed_file.h\"   // produced by the IDL generator\n";
      }
      else if (!strncmp(p, "${module_start}", 15)) {
	p += 15;
	s += mod_start;
      }
      else if (!strncmp(p, "${definition}", 13)) {
	p += 13;
	if (*p == '\n')
	  p += 1;
	
	unsigned n = lb_cl_associated->count();
	
	for (unsigned i = 0; i != n; i += 1) {
	  BrowserNode * bn =
	    ((ListBoxBrowserNode *) lb_cl_associated->item(i))->browser_node;
	  ClassData * c = (ClassData *) bn->get_data();
	  
	  ClassDialog::idl_generate_decl(s, c, c->get_idldecl(), bn->get_name(),
					 c->get_stereotype(),
					 c->get_base_type().get_type(),
					 bn->get_comment(), c->get_switch_type().get_type(),
					 c->idl_is_local(), c->idl_is_custom(),
					 c->get_is_abstract(), 0);
	  s += '\n';
	}
      }
      else if (!strncmp(p, "${module_end}", 13)) {
	p += 13;
	s += mod_end;
	
	if (*p == '\n')
	  p += 1;
      }
      else
	// strange
	s += *p++;
    }
    
    showidl_content->setText(s);
  }
}

void ArtifactDialog::associate_cls() {
  unsigned int i = 0;
  
  while (i < lb_cl_available->count()) {
    QListBoxItem * item = lb_cl_available->item(i);
    
    if (item->selected()) {
      lb_cl_available->takeItem(item);
      lb_cl_associated->insertItem(item);

      ClassData * c = (ClassData *)
	((ListBoxBrowserNode *) item)->browser_node->get_data();
      
      if (c->get_cppdecl()[0])
	n_cpp += 1;
      if (c->get_javadecl()[0])
	n_java += 1;
      if (c->get_phpdecl()[0])
	n_php += 1;
      if (c->get_idldecl()[0])
	n_idl += 1;
    }
    else
      i += 1;
  }
}

void ArtifactDialog::unassociate_cls() {
  unsigned int i = 0;
  
  while (i < lb_cl_associated->count()) {
    QListBoxItem * item = lb_cl_associated->item(i);
    
    if (item->selected()) {
      lb_cl_associated->takeItem(item);
      lb_cl_available->insertItem(item);

      ClassData * c = (ClassData *)
	((ListBoxBrowserNode *) item)->browser_node->get_data();
      
      if (c->get_cppdecl()[0])
	n_cpp -= 1;
      if (c->get_javadecl()[0])
	n_java -= 1;
      if (c->get_phpdecl()[0])
	n_php -= 1;
      if (c->get_idldecl()[0])
	n_idl -= 1;
    }
    else
      i += 1;
  }
  
  lb_cl_available->sort();
}

void ArtifactDialog::move_cls_up() {
  unsigned n = lb_cl_associated->count();
  
  if ((n > 1) && !lb_cl_associated->item(0)->selected()) {
    for (unsigned i = 1; i != n; i += 1) {
      QListBoxItem * item = lb_cl_associated->item(i);
      
      if (item->selected()) {
	lb_cl_associated->takeItem(item);
	lb_cl_associated->insertItem(item, i - 1);				    
      }
    }
  }
}

void ArtifactDialog::move_cls_down() {
  int n = (int) lb_cl_associated->count();
  
  if ((n > 1) && !lb_cl_associated->item(n - 1)->selected()) {
    for (int i = n - 2; i >= 0; i -= 1) {
      if (lb_cl_associated->item(i)->selected()) {
	QListBoxItem * item = lb_cl_associated->item(i + 1);
      
	lb_cl_associated->takeItem(item);
	lb_cl_associated->insertItem(item, i);				    
      }
    }
  }
}

void ArtifactDialog::associate_arts() {
  unsigned int i = 0;
  
  while (i < lb_art_available->count()) {
    QListBoxItem * item = lb_art_available->item(i);
    
    if (item->selected()) {
      lb_art_available->takeItem(item);
      lb_art_associated->insertItem(item);
      
      BrowserArtifact * c = (BrowserArtifact *)
	((ListBoxBrowserNode *) item)->browser_node;
      
      art_associated.insert(c, c);
    }
    else
      i += 1;
  }
  
  lb_art_associated->sort();
}

void ArtifactDialog::unassociate_arts() {
  unsigned int i = 0;
  
  while (i < lb_art_associated->count()) {
    QListBoxItem * item = lb_art_associated->item(i);
    
    if (item->selected()) {
      lb_art_associated->takeItem(item);
      lb_art_available->insertItem(item);
      art_associated.remove(((ListBoxBrowserNode *) item)->browser_node);
    }
    else
      i += 1;
  }
  
  lb_art_available->sort();
}

void ArtifactDialog::stereotypeFilterActivated(const QString & st) {
  if (!hasOkButton()) {
    QPtrDictIterator<BrowserArtifact> it(art_associated);
    
    while (it.current()) {  
      lb_art_associated->insertItem(it.current()->full_name(TRUE));
      ++it;
    }
    
    lb_art_associated->sort();
  }
  else {
    QString s = st.stripWhiteSpace();
    BrowserNodeList artifacts;
    BrowserNode * itself = data->browser_node;
    BrowserNode * cp;
    
    BrowserArtifact::instances(artifacts, s);
    lb_art_available->clear();
    lb_art_associated->clear();
    
    for (cp = artifacts.first(); cp !=0; cp = artifacts.next()) {
      if (cp != itself) {
	if (art_associated.find(cp))
	  lb_art_associated->insertItem(new ListBoxBrowserNode(cp, cp->full_name(TRUE)));
	else
	  lb_art_available->insertItem(new ListBoxBrowserNode(cp, cp->full_name(TRUE)));
      }
    }
    
    lb_art_available->sort();
    lb_art_associated->sort();
  }
}

void ArtifactDialog::accept() {
  if (!check_edits(edits))
    return;
    
  QString s = edname->text().stripWhiteSpace();
  BrowserArtifact * bn = (BrowserArtifact *) data->get_browser_node();
  
  if ((s != bn->get_name()) &&
      ((BrowserNode *) bn->parent())->wrong_child_name(s, UmlArtifact,
						       bn->allow_spaces(),
						       bn->allow_empty()))
    msg_critical("Error", edname->text() + "\n\nillegal name or already used");
  else {  
    bn->set_name(s);
    bn->set_comment(comment->text());
    UmlWindow::update_comment_if_needed(bn);
        
    QString stereotype = 
      fromUnicode(edstereotype->currentText().stripWhiteSpace());
    bool a_text = (stereotype == "text");
    
    data->set_stereotype(stereotype);
    
    if (a_text || (stereotype == "source")) {
      QValueList<BrowserClass *> l;
      
      if (! a_text) {
	unsigned n = lb_cl_associated->count();
	
	for (unsigned i = 0; i != n; i += 1)
	  l.append((BrowserClass *)
		   (((ListBoxBrowserNode *) lb_cl_associated->item(i))
		    ->browser_node));
      }
      
      bn->set_associated_classes(l);
      
      if (isTabEnabled(cpp_h_content_page)) {
	data->cpp_h = edcpp_h_content->text();
      }
      else
	data->cpp_h = QString::null;
      
      if (isTabEnabled(cpp_src_content_page)) {
	data->cpp_src = edcpp_src_content->text();
      }
      else
	data->cpp_src = QString::null;
      
      if (isTabEnabled(java_content_page)) {
	data->java_src = edjava_content->text();
      }
      else
	data->java_src = QString::null;
      
      if (isTabEnabled(php_content_page)) {
	data->php_src = edphp_content->text();
      }
      else
	data->php_src = QString::null;
      
      if (isTabEnabled(idl_content_page)) {
	data->idl_src = edidl_content->text();
      }
      else
	data->idl_src = QString::null;
    }
    else 
      data->update_associated(art_associated);
    
    kvtable->update(bn);
  
    bn->modified();
    bn->package_modified();
    data->modified();
    
    QTabDialog::accept();
  }
}
