// distribution boxbackup-0.10 (svn version: 494)
//  
// Copyright (c) 2003 - 2006
//      Ben Summers and contributors.  All rights reserved.
//  
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. All use of this software and associated advertising materials must 
//    display the following acknowledgment:
//        This product includes software developed by Ben Summers.
// 4. The names of the Authors may not be used to endorse or promote
//    products derived from this software without specific prior written
//    permission.
// 
// [Where legally impermissible the Authors do not disclaim liability for 
// direct physical injury or death caused solely by defects in the software 
// unless it is modified by a third party.]
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
// ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//  
//  
//  
// --------------------------------------------------------------------------
//
// File
//		Name:    TemporaryDirectory.h
//		Purpose: Location of temporary directory
//		Created: 2003/10/13
//
// --------------------------------------------------------------------------

#ifndef TEMPORARYDIRECTORY__H
#define TEMPORARYDIRECTORY__H

#include <string>

#ifdef WIN32
	#include <windows.h>
#endif

// Prefix name with Box to avoid clashing with OS API names
std::string BoxGetTemporaryDirectoryName()
{
#ifdef WIN32
	// http://msdn.microsoft.com/library/default.asp?
	// url=/library/en-us/fileio/fs/creating_and_using_a_temporary_file.asp

	DWORD dwRetVal;
	char lpPathBuffer[1024];
	DWORD dwBufSize = sizeof(lpPathBuffer);
	
	// Get the temp path.
	dwRetVal = GetTempPath(dwBufSize,     // length of the buffer
						   lpPathBuffer); // buffer for path 
	if (dwRetVal > dwBufSize)
	{
		THROW_EXCEPTION(CommonException, TempDirPathTooLong)
	}
	
	return std::string(lpPathBuffer);
#elif defined TEMP_DIRECTORY_NAME
	return std::string(TEMP_DIRECTORY_NAME);
#else	
	#error non-static temporary directory names not supported yet
#endif
}

#endif // TEMPORARYDIRECTORY__H
