/********************************************************************
 * Copyright (C) 2005 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BSCommander is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BSCommander is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/

/*------- include files:
-------------------------------------------------------------------*/
#include "ConsoleConfig.h"
#include "Shared.h"
#include "Config.h"
#include "Settings.h"
#include <qlabel.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>

/*------- local constants:
-------------------------------------------------------------------*/
const QString ConsoleConfig::OtherTerminal = QT_TR_NOOP( "&Other terminal" );
const QString ConsoleConfig::KonsoleName   = QT_TR_NOOP( "Default terminal: <b>konsole</b>" );


//*******************************************************************
// ConsoleConfig                                         CONSTRUCTOR
//*******************************************************************
ConsoleConfig::ConsoleConfig( QWidget* const in_parent )
: QFrame( in_parent )
, d_main_layout( new QVBoxLayout( this ) )
, d_konsole_grpbox( new QGroupBox( 2, Qt::Vertical, this ))
, d_konsole_name( new QLabel( tr(KonsoleName), d_konsole_grpbox ))
, d_konsole_call( new QLineEdit( Shared::KonsoleCall, d_konsole_grpbox ))
, d_other_grpbox( new QGroupBox( 2, Qt::Vertical, this ))
, d_other_cbox( new QCheckBox( tr(OtherTerminal), d_other_grpbox ))
, d_other_call( new QLineEdit( d_other_grpbox ))
, d_button_layout( new QHBoxLayout )
, d_apply_button( new QPushButton( tr(Shared::ApplyBtnLabel), this ))
{
	d_main_layout->setSpacing( Shared::LayoutSpacing );
	d_main_layout->setMargin( Shared::LayoutMargin );

	// konsole
	d_konsole_call->setReadOnly( TRUE );
	d_main_layout->addWidget( d_konsole_grpbox );
	
	// other
	//d_other_call->setEnabled( FALSE );
	d_main_layout->addWidget( d_other_grpbox );

	// apply
	Shared::add_icon( d_apply_button, Shared::ApplyIcon );
	d_button_layout->addStretch( Shared::OverStretch );
	d_button_layout->addWidget( d_apply_button );
	d_main_layout->addLayout( d_button_layout );	
	
	connect( d_other_cbox, SIGNAL( toggled( bool )), this, SLOT( other_toggled( bool )));
	connect( d_apply_button, SIGNAL( clicked() ), this, SLOT( apply_clicked() ));
}
// end of ConsoleConfig

//*******************************************************************
// show                                            PRIVATE inherited
//*******************************************************************
void ConsoleConfig::show()
{
	const QString call = Config::instance()->terminal_call();
	if( call.isEmpty() ) {
		d_other_call->setEnabled( FALSE );
	}
	else {
		d_other_call->setText( call );
		d_other_cbox->setChecked( TRUE );
	}
	QFrame::show();
}
// end of show

//*******************************************************************
// other_toggled                                        PRIVATE slot
//*******************************************************************
void ConsoleConfig::other_toggled( const bool in_on )
{
	d_other_call->setEnabled( in_on );
	if( in_on ) d_other_call->setFocus();
}
// end of other_toggled

//*******************************************************************
// apply_clicked                                        PRIVATE slot
//*******************************************************************
void ConsoleConfig::apply_clicked()
{
	const QString call = ( d_other_cbox->isChecked() ) ? d_other_call->text() : "";
	Settings::save( Config::AppConfigGroup, Config::TerminalKey, call );
	Config::instance()->refresh();
}
// end of apply_clicked
