/***************************************************************************
 *   Copyright (C) 2005 by Tomeu Borras Riera                              *
 *   tborras@conetxia.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef BUSQUEDAARTICULO_H
#define BUSQUEDAARTICULO_H

#include <QLineEdit>
#include <QLabel>
#include <QComboBox>
#include "postgresiface2.h"

#include "ui_busquedaarticulobase.h"


class company;


class BusquedaArticuloDelegate : public QComboBox {
Q_OBJECT
private:
	company *m_companyact;
    /// Este cursor almacena el listado de series de factura para poder trabajar con ellas.
    cursor2 *m_cursorcombo;

public:
    BusquedaArticuloDelegate(QWidget *parent = 0);
    ~BusquedaArticuloDelegate();
    void setcompany(company *comp) {
        m_companyact = comp;
    };
public slots:
    virtual void s_editTextChanged(const QString &);
};



/// Permite buscar y seleccionar un art&iacute;culo.
/** Muestra la parte del formulario que permite buscar y seleccionar un
    art&iacute;culo. */
class BusquedaArticulo : public QWidget, public Ui_BusquedaArticuloBase {
    Q_OBJECT

private:
    /// Puntero de la clase company que permite trabajar con la base de datos y el paso de mensajes.
    company *companyact;
    /// El Widget almacena el idarticulo seleccionado en esta variable.
    QString mdb_idarticulo;
    /// BusquedaArticulo almacena el nombre del articulo seleccionado en esta variable.
    QString mdb_nomarticulo;
    /// BusquedaArticulo almacena el codigo completo del articulo seleccionado en esta variable de clase.
    QString mdb_codigocompletoarticulo;

public:
    BusquedaArticulo(QWidget *parent = 0);
    ~BusquedaArticulo();
    void setcompany(company *comp) {
        companyact = comp;
    };
    virtual QString codigocompletoarticulo() {
        return m_codigocompletoarticulo->text();
    };
    virtual QString idarticulo() {
        return mdb_idarticulo;
    };
    virtual QString nomarticulo() {
        return m_nomarticulo->text();
    };
    virtual void setidarticulo(QString val);
    virtual void setcodigocompletoarticulo(QString val);

public slots:
    virtual void on_mui_buscar_clicked();
    virtual void on_m_codigocompletoarticulo_textChanged(const QString &);

signals:
    void valueChanged(QString);
};

#endif

