package buoy.event;

import buoy.widget.*;
import java.awt.event.*;

/**
 * This is an event corresponding to a Unicode character being generated by the user interacting with the
 * keyboard.  The exact relationship between the keyboard interaction and the resulting KeyTypedEvents may
 * be complex.  Several different key presses may contribute to a single KeyTypedEvent (such as holding down
 * the Shift key while typing a letter), or a single key press may generate multiple KeyTypedEvents (such
 * as holding down a key to activate autorepeat).
 *
 * @author Peter Eastman
 */

public class KeyTypedEvent extends WidgetKeyEvent
{
  /**
   * Create a KeyTypedEvent.
   *
   * @param source        the Widget which generated this event
   * @param when          the time at which the event occurred
   * @param modifiers     describes the state of various keys and buttons at the time when the event occurred
   *                      (a sum of the constants defined by InputEvent)
   * @param keyChar       the Unicode character generated by this event
   */
  
  public KeyTypedEvent(Widget source, long when, int modifiers, char keyChar)
  {
    super(source, KeyEvent.KEY_TYPED, when, modifiers, VK_UNDEFINED, keyChar);
  }
}