/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.freedesktop.cairo;

import org.gnu.glib.Handle;

public class FontExtents extends CairoObject {

    FontExtents(Handle hndl) {
        super(hndl);
    }

    protected void finalize() throws Throwable {
        free(getHandle());
        super.finalize();
    }

    public double getAscent() {
        return get_ascent(getHandle());
    }

    public double getDescent() {
        return get_descent(getHandle());
    }

    public double getHeight() {
        return get_height(getHandle());
    }

    public double getMaxXAdvance() {
        return get_max_x_advance(getHandle());
    }

    public double getMaxYAdvance() {
        return get_max_y_advance(getHandle());
    }

    /*
     * Native calls
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    native static final private void free(Handle obj);

    native static final private double get_ascent(Handle obj);

    native static final private double get_descent(Handle obj);

    native static final private double get_height(Handle obj);

    native static final private double get_max_x_advance(Handle obj);

    native static final private double get_max_y_advance(Handle obj);
}
