/*  audiodevs: Abstraction layer for audio hardware & samples
    Copyright (C) 2003-2004 Nemosoft Unv.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For questions, remarks, patches, etc. for this program, the author can be
    reached at camstream@smcc.demon.nl.
*/

#ifndef SOUNDATTRS_H
#define SOUNDATTRS_H

#include <sys/types.h>

#ifdef _WIN32
typedef char           int8_t;
typedef unsigned char  u_int8_t;
typedef __int16        int16_t;
typedef unsigned short u_int16_t;
typedef long           int32_t;
typedef unsigned long  u_int32_t;
#endif

struct SoundAttributes
{
   /** The various sample formats */
   enum Format
   {
     Unknown,
     Signed8,
     Signed16,
     Signed24,
     Signed32,
     Unsigned8,
     Unsigned16,
     Unsigned24,
     Unsigned32,
     Float,
   };

   /** Designation per channel */
   enum Position
   {
      NotUsed = -1,
      Mono = 32,
      Left,		///< Front left
      Right,		///< Front right
      Center,
      LeftRear,		///< 5.1 sound
      RightRear,	///< 5.1 sound
      LFE,		///< Low Frequency Effects = subwoofer
      LeftCenter,	///< 7.1 sound
      RightCenter,	///< 7.1 sound
      Top,		///< Overhead (does this get used at all?)
      MaxPosition = 64
   };

   /** Some presets */
   enum Preset
   {
      Speech,		///< 8 KHz, mono, 8 bits unsigned
      Radio,		///< 22 KHz, mono, 16 bits signed
      CD,		///< 44.1 KHz, stereo, 16 bits signed
      DAT,		///< 48 KHz, stereo, 16 bits signed
      Dolby51,		///< 5.1 surround, left/right/center/lrear/rrear/lfe, 16 bits signed

   };

   enum Channels
   {
      MaxChannel = 32
   };

   unsigned int   SampleRate;                  ///< Frequency at which samples are taken
   Format         SampleFormat;
   unsigned short Channels;                    ///< 1 to 32; see \ref ChannelPosition
   Position       ChannelPosition[MaxChannel]; ///< Per channel position info

   SoundAttributes();

   void Reset();
   void SetPreset(Preset);

   unsigned int FormatWidth() const;
   unsigned int BytesPerSample() const;

   bool operator ==(const SoundAttributes &comp) const;
   bool operator !=(const SoundAttributes &comp) const;

   static SoundAttributes GetFormat(Preset fmt);
};

#endif
