/*  audiodevs: Abstraction layer for audio hardware & samples
    Copyright (C) 2003-2004 Nemosoft Unv.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For questions, remarks, patches, etc. for this program, the author can be
    reached at camstream@smcc.demon.nl.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <assert.h>

#include <qapplication.h>
#include <qcombobox.h>
#include <qkeycode.h>
#include <qlineedit.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qworkspace.h>

#include "tracer.h"

#include "AudioCollector.h"
#include "AudioDisplay.h"
#include "AudioOpenDlg.h"
#include "MainWindow.h"

TR_MODULE("MainWindow");

CMainWindow::CMainWindow(QWidget *parent, const char *name)
	: QMainWindow(parent, name)
{
   QPixmap BackgroundPix;
   QPopupMenu *menu;

   BackgroundPix.resize(16, 16);
   BackgroundPix.fill(lightGray);
   m_pWorkspace = new QWorkspace(this);
   assert(m_pWorkspace != NULL);
   m_pWorkspace->setBackgroundPixmap(BackgroundPix);
   setCentralWidget(m_pWorkspace);

   // Create menu structure
   menu = new QPopupMenu(this, "File menu");
   menu->insertItem("&Open...", this, SLOT(FileOpenNew()), CTRL + Key_O);
   menu->insertItem("&Quit",    this, SLOT(FileQuit()),    CTRL + Key_Q);
   menuBar()->insertItem("&File", menu);

   menu = new QPopupMenu(this, "Window menu");
   menu->insertItem("&Cascade", m_pWorkspace, SLOT(cascade()));
   menu->insertItem("&Tile",    m_pWorkspace, SLOT(tile()));
   menuBar()->insertItem("&Window", menu);
}

CMainWindow::~CMainWindow()
{
   qDebug("CMainWindow::~CMainWindow()");
}

// private slots

void CMainWindow::FileOpenNew()
{
   uint i;
   CAudioOpenDlg OpenDlg(0, "Audio Open Dialog", true);
   CAudioCollector *au = CAudioCollector::Instance();
   CAudioDevice *adev = 0;

qDebug("CMXMainwWindow::FileOpenNew() called.");
   for (i = 0; i < au->NumberOfAudioDevices(); i++)
   {
      adev = au->GetAudioDevice(i);
      if (adev == 0)
        continue;
      OpenDlg.m_DevicesComboBox->insertItem(adev->GetName(), i);
   }

   if (OpenDlg.exec() == QDialog::Accepted)
   {
     int sel_device;

     sel_device = OpenDlg.m_DevicesComboBox->currentItem();
     adev = au->GetAudioDevice(sel_device);
     if (adev != 0)
     {
       CAudioDisplay *ad = new CAudioDisplay(adev, m_pWorkspace, "audio display");
       if (ad)
         ad->show();
     }
   }
}


void CMainWindow::FileQuit()
{
qDebug("CMainWindow::FileQuit() called.");
   qApp->quit(); // we're done
}

// public

void CMainWindow::OpenAudio(const char *audio_dev)
{
/*
   CAudioDisplay *pDisplay;

   pDisplay = new CAudioDisplay(audio_dev, Workspace);
   if (pDisplay)
     pDisplay->show();
   else
     qWarning("Could not create new AudioDisplay. Out of memory?");
*/
}
