from lib.common import *
from manager.dbusinterface import get_dbus_interface as get_manager_dbus_interface 

class BaseChecker:
	def __init__(self, notifier, account_id, set_status_cb):
		self.account_id = account_id
		self.set_status_cb = set_status_cb

		self.checking = False
		self.notifier = notifier
		
		self.manager_iface = None
		
	def reset(self): 
		"""
		After this method is invoked, the checker must consider
		all mails as not notified
		"""
		raise NotImplementedError()

	def __error(self, e): pass
	def __reply(self): pass
	
	def start_check(self):
		self.checking = True
		gtk.gdk.threads_enter()
		try:
			self.manager_iface = get_manager_dbus_interface()
			if self.manager_iface is not None:
				self.manager_iface.set_refreshing(self.account_id, True,
							reply_handler = self.__reply,
							error_handler = self.__error)
		except:
			print "Warning: BaseChecker -> start_check"
			pass
		gtk.gdk.threads_leave()
		
	def stop_check(self):
		self.checking = False
		gtk.gdk.threads_enter()
		try:
			if self.manager_iface is not None:
				self.manager_iface.set_refreshing(self.account_id, False,
							reply_handler = self.__reply,
							error_handler = self.__error)
		except:
			print "Warning: BaseChecker -> stop_check"
			pass
		gtk.gdk.threads_leave()
	
	def notify_error(self, error, text, f):
		self.notifier.notify(error, text, msec = 10000, 
			buttons = False, error = True, force = f)
	
	def notify_msg(self, mailbox, count, mails):
		gtk.gdk.threads_enter()

		subject_i18n = _(u"<b>Subject:</b>")
		author_i18n = _(u"<b>From:</b>")
		message = u""
		total = 0
		mailboxname = _("<b>Box:</b> %s") % mailbox
		total += count
		for author, subject in mails:
			try:
				author = unicode(author, "utf-8")
			except UnicodeDecodeError:
				author = unicode(author, "latin-1", "replace")
			except:
				pass
			try:
				subject = unicode(subject, "utf-8")
			except UnicodeDecodeError:
				subject = unicode(subject, "latin-1", "replace")
			except:
				pass
			try:
				message += u"%s %s\n%s %s\n%s\n\n" % \
					(subject_i18n, subject,
					author_i18n, author, mailboxname)
			except:
				message += u"%s %s\n%s %s\n%s\n\n" % \
					(subject_i18n, _("Unknown"),
					author_i18n, _("Unknown"), mailboxname)
		if total > 1:
			title = _("There are %s new mails") % total
		else:
			title = _("There is a new mail")

		self.set_status_cb(self.account_id, count, title, message)

		gtk.gdk.threads_leave()
		
	def check(self): 
		"""
		Must return a list of 3 elements. First element must
		be the mailbox name, second the message count into mailbox, 
		third element a list of tuple. Each
		tuple must contain the from and subject field of the email
		Example:
			["test@gmail.com", 2, [ ["Test Mailer <test@domain.com>", "This is the subject"], 
					["Second <sec@test.com>", "Second Subject"] ]]
		"""
		raise NotImplementedError()
	
	def update_info(self, account):
		"""
		This method receive an account dic and update checker info
		using account values
		"""
		raise NotImplementedError()

