import gtk
import thread
import checker
import time
import traceback

if gtk.pygtk_version < (2, 10, 0):
	import sys
	print _("You need pygtk >= 2.10 to run cgmail.")
	sys.exit(1)

import dbus
import dbus.mainloop.glib
import gobject

from statusicon import StatusIcon
from statusawn import StatusAWN
from lib.gconfhelper import GconfHelper
from notifier import Notifier
from dbusinterface import ServiceDbusInterface


#gobject.threads_init()
gtk.gdk.threads_init()

class MainLoop:
	def __init__(self):
		self.notifier = Notifier()
		
		self.checker = checker.Checker(self.notifier)

		self.statusicon = StatusIcon(self.notifier, self.checker, self.stop)

		self.gconf_helper = GconfHelper()

		if self.gconf_helper.get_key("awn_enabled") == True:
			print "Enabling AWN notifications"
			awn_app_name = self.gconf_helper.get_key("awn_application_name")
			self.statusawn = StatusAWN(self.checker, awn_app_name)
		
		# start dbus service
		dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)
		session_bus = dbus.SessionBus()
		name = dbus.service.BusName("org.tuxfamily.cgmail.Service", session_bus)
		dbus_service = ServiceDbusInterface(session_bus, '/Service')
		dbus_service.set_on_exit_cb(self.stop)
		dbus_service.set_on_refresh_cb(self.force_check)

		#self.must_exit = False
		try:
			#self.run()
			#self.mainloop = gobject.MainLoop()
			gobject.idle_add(self.main_iteration)
			#self.mainloop.run()
			gtk.main()
		except KeyboardInterrupt:
			#self.must_exit = True
			pass
	
	def force_check(self):
		print "force check"
		self.checker.reset()
		try:
			self.checker.check()
		except Exception, e:
			traceback.print_exc()
			print "Warning: ", e

	def stop(self):
		print "stop called"
		#self.must_exit = True
		#self.mainlooop.quit()
		gtk.main_quit()

	def main_iteration(self):
		#stime = 0 
		#sleep_time = self.gconf_helper.get_key("check_interval")
		#while not self.must_exit:
		#while gtk.events_pending():
		#	gtk.main_iteration()
		#time.sleep(0.01)
		#ctime = time.time()
		#elapsed = ctime - stime
		#if elapsed > sleep_time:
		sleep_time = self.gconf_helper.get_key("check_interval")
		#	stime = ctime
		try:
			#thread.start_new_thread(self.checker.check, ())
			self.checker.check()
			#pass
		except Exception, e:
			traceback.print_exc()
			print "Warning: ", e
		gobject.timeout_add(sleep_time * 1000, self.main_iteration)

		# Don't return True here. See gobject.timeout_add docs
		return False

