/***************************************************************************/
/* 		This code is part of Desktop Background changer		   */
/*		called ChBg						   */
/*		Copyright (c) 1999, 2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <dirent.h>
#include <ctype.h>
#include <unistd.h>

#include <glib.h>

#ifdef HAVE_FNMATCH
#include <fnmatch.h>
#else
#include "fnmatch.h"
#endif

#include "config.h"
#include "recurse.h"

static char *lowerstr(s)
char *s;
{
	char *p ;

	for(p = s ; *p != '\0' ; p ++) *p = tolower(*p);

	return s;
}

static int check_pattern(patterns, str)
GSList *patterns;
char *str;
{
	GSList *ptr = patterns;
	char *mstr;

	if (!ptr) return TRUE;

	mstr = g_strdup(str);
	lowerstr(mstr);

	while(ptr)
	{
		char *pat = g_strdup(ptr->data);
		lowerstr(pat);

		if (!fnmatch(pat, mstr, FNM_PATHNAME))
		{
			g_free(pat);
			g_free(mstr);
			return TRUE;
		}
		g_free(pat);
		ptr = ptr->next;
	}

	return FALSE;
}

void recurse_dir(rlist, num_pics, patterns, minsize, getname_func, newentry_func, free_func)
GList **rlist;
int *num_pics;
GSList *patterns;
int minsize;
recurse_getname_func getname_func;
recurse_newentry_func newentry_func;
recurse_free_func free_func;
{
	GList *ptr = *rlist;
	GList *pptr;
	struct stat estat;
	void *entry;

	while(ptr)
	{
		pptr = ptr->next;
		if (!stat(getname_func(ptr->data), &estat))
		{
			if (S_ISDIR(estat.st_mode))
			{
				DIR *d = opendir(getname_func(ptr->data));
				struct dirent *dent;

				if (d)
				{
					while((dent = readdir(d)))
					{
						char *ps,*tmp;
						int sr;

						if (!strcmp(dent->d_name, ".") ||
						     !strcmp(dent->d_name, ".."))
							continue;

						ps = g_strconcat(getname_func(ptr->data), "/", dent->d_name, NULL);

						sr = stat(ps, &estat);

						if (!sr && !S_ISDIR(estat.st_mode))
						{
							if (estat.st_size < (minsize * 1024))
							{
								g_free(ps);
								continue;
							}

							if (!check_pattern(patterns, dent->d_name))
							{
								g_free(ps);
								continue;
							}

						}
#ifdef S_ISLNK
						/* to prevent possible cyclicing caused */
						/*  by backward pointing symbolic links! */
						if (!sr && S_ISDIR(estat.st_mode))
						{
							int l;
							char linkp[PATH_MAX];
							sr = lstat(ps, &estat);
							if (!sr &&
							    S_ISLNK(estat.st_mode) &&
							    ((l = readlink(ps, linkp, sizeof(linkp)-1)) > 0))
							{
								linkp[l] = '\0';
								l = strlen(linkp);
								if (!strncmp(ps, linkp, l) &&
								    (ps[l] == '/' || linkp[l-1] == '/'))
								{
									g_free(ps);
									continue;
								}
							}
						}
#endif
						tmp = ps;
						ps = simplify_path(ps);
						g_free(tmp);

						entry = newentry_func(ps, ptr->data);
						*rlist = g_list_append(*rlist, entry);
						if (num_pics) (*num_pics) ++;
					}
					closedir(d);
					pptr = ptr->next;	
					free_func(ptr->data);
					*rlist = g_list_remove_link(*rlist, ptr);
					if (num_pics) (*num_pics) --;
				}
			}
		}
		ptr = pptr;
	}
}

