#include "cp_types.h"
#include "cp_proto.h"

/* given an edge_pair index, apply corresponding mobius 
transform to the packing. */

int apply_pair_mobius(struct p_data *p,char *datastr)
{
  int flag=1,n;
  char *nextptr,next[128];
  Mobius Mob;

  nextptr=datastr;
  if (!p->redfaces || !grab_next(&nextptr,next)) return 0;
  if (!strcmp(next,"-1")) 
    {
      flag=-1;
      grab_next(&nextptr,next);
    }
  if (!sscanf(next,"%d",&n)
      || n<1 || n>3*MAX_COMPONENTS || !p->edge_pair[n].edge)
    return 0;
  if (!p->edge_pair[n].mate) return 1; /* no paired edge */
  Mob=p->edge_pair[n].mob;
  apply_Mobius(p,"a",flag,Mob);
  return 1;
} /* apply_pair_mobius */


