#include "cp_types.h"
#include "cp_proto.h"

/* Store list of verts with radii < 2 times the smallest radius
in /tmp/small_rads_log. Report smallest rad, its vert, and count 
of verts in the list. */

int diag_small_rads(struct p_data *p)
{
  int i,vert,count=0;
  double sv,rad;
  struct R_data *pR_ptr;
  FILE *diagfp;

  pR_ptr=p->packR_ptr;
  vert=p->alpha;
  sv=fabs(pR_ptr[p->alpha].rad);
  for (i=1;i<=p->nodecount;i++)
    if ((rad=pR_ptr[i].rad) > 0 && rad<sv)
      {
	vert=i;
	sv=rad;
      }
  sprintf(msgbuf,"Diag: The smallest radius is %f at vertex %d.\n"
	  "See /tmp/small_rads_log for list of vertices with radius"
	  "no bigger than twice the smallest.",sv,vert);

  if (!(diagfp=fopen("/tmp/small_rads_log","w")))
    {
      sprintf(msgbuf,"couldn't open /tmp/small_rads_log");
      emsg();
      return 0;
    }
  fprintf(diagfp,"Packing %s, %d nodecount, hes=%d\nSmallest"
	  "radius %f at vert %d.\n"
	  "Here are the verts with radius less than %f :",
	  p->file_name,p->nodecount,p->hes,sv,vert,2.0*sv);
  sv=2.0*sv;
  for (i=1;i<=p->nodecount;i++)
    if (pR_ptr[i].rad<sv) 
      {
	fprintf(diagfp," %d ",i);
	count++;
      }
  fprintf(diagfp,"\nThere were %d vertices with 'small' radii.\nEND\n",
	  count);
  fclose(diagfp);
  return vert;
} /* diag_small_rads */
