#include "cp_types.h"
#include "cp_proto.h"

/* convert parse symbol to double.
cf: 0=faces, 1=circles. return 0 on error or inapprop request. 
   Target quantities: rad=r, degree=d, bdry=b, int=i, 
     angle sum=s, aim=a, marked=m, ratio(p,q)=cpq,
     ratio(p,q)=epq (but converted to eucl), 
     modulus of (eucl) center=z (or ze), plot_flag false=x. */

int symb_to_value(struct p_data *p,char *datastr,int node,int cf,double *val)
{
  int pp=0,pq=0;
  double rp,rq;
  complex ctrp,ctrq;

  stripsp(datastr);
  if (*datastr<'a' || *datastr>'z') /* look for numeric value */
    {
      if (!sscanf(datastr,"%lf",val)) return 0;
      return 1;
    }
  switch (*datastr)
    {
    case 'a': /* aim? */
      {
	if (!cf) return 0;
	*val=p->packR_ptr[node].aim/M_PI;
	return 1;
      }
    case 'b': /* boundary object? */
      {
	if (cf) *val=(double)(p->packK_ptr[node].bdry_flag);
	else *val=(double)(p->packK_ptr[p->faces[node].vert[0]].bdry_flag
			   || p->packK_ptr[p->faces[node].vert[1]].bdry_flag 
			   || p->packK_ptr[p->faces[node].vert[2]].bdry_flag);
	return 1;
      }
    case 'd': /* degree? */
      {
	if (!cf) return 0;
	*val=(double)(p->packK_ptr[node].num+
		      p->packK_ptr[node].bdry_flag); /* add 1 if bdry vert */
	return 1;
      }
    case 'R': /* ratio of radii? */
    case 'E': /* ratio, but using eucl radii? (e.g. "e21", pack2/pack1) */
      {
	if (!cf) return 0;
	if (*(datastr+1)>='0' && *(datastr+1)<='9') pp=*(datastr+1)-'0';
	if (*(datastr+2)>='0' && *(datastr+1)<='9') pq=*(datastr+2)-'0';
	/* caution: will crash if pp or pq is out of range for packdata */
	if (node>packdata[pp].nodecount 
	    || node>packdata[pq].nodecount) 
	  return 0;
	rq=packdata[pq].packR_ptr[node].rad;
	rp=packdata[pp].packR_ptr[node].rad;
	if (*datastr=='e') /* compare in eucl geom */ 
	  {
	    if (packdata[pp].hes<0) 
	      h_to_e_data(packdata[pp].packR_ptr[node].center,
			  rp,&ctrp,&rp);
	    if (packdata[pq].hes<0) 
	      h_to_e_data(packdata[pq].packR_ptr[node].center,
			  rq,&ctrq,&rq);
	  }
	*val=rp/rq; /* may be NaN */
	return 1;
      }
    case 'i': /* interior object? */
      {
	if (cf) *val=(double)(!p->packK_ptr[node].bdry_flag);
	else  *val=(double)(!p->packK_ptr[p->faces[node].vert[0]].bdry_flag
		    && !p->packK_ptr[p->faces[node].vert[1]].bdry_flag 
		    && !p->packK_ptr[p->faces[node].vert[2]].bdry_flag);
	return 1;
      }
    case 'm': /* marked object? */
      {
	if (cf) *val=(double)p->packK_ptr[node].mark;
	else *val=(double)p->faces[node].mark;
	return 1;
      }
    case 'n': /* vert or face index */
      {
	*val=(double)node;
	return 1;
      }
    case 'q': /* active circle */
      {
	if (cf && (p->active_node==node)) {*val=1.0;return 1;}
	else return 0;
      }    
    case 'r': /* rad? */
      {
	if (!cf) return 0;
	*val=p->packR_ptr[node].rad;
	return 1;
      }
    case 's': /* angle sum? */
      {
	if (!cf) return 0;
	*val=p->packR_ptr[node].curv/M_PI;
	return 1;
      }
    case 'u': /* util_flag? */
      {
	if (!cf && p->f_util) *val=(double)p->f_util[node];
	else if (!cf) *val=0;
	else *val=(double)p->packK_ptr[node].util_flag;
	return 1;
      }
    case 'x': /* !plot_flag? */
      {
	if (cf) *val=(double)p->packK_ptr[node].plot_flag;
	else *val=(double)p->faces[node].plot_flag;
	return 1;
      }
    case 'z': /* modulus of center */
      {
	if (!cf || p->hes>0) return 0; /* not yet for sph case */
	ctrp=p->packR_ptr[node].center;
	if (p->hes<0 && *(datastr+1)=='e') /* want eucl center */
	  h_to_e_data(ctrp,p->packR_ptr[node].rad,&ctrp,&rp);
	*val=cAbs(ctrp); 
	return 1;
      }
    } /* end of switch */
  return 0; /* no valid symbol */
} /* symb_to_value */
