      SUBROUTINE DRGLGB(B, D, DR, IV, LIV, LV, N, ND, NN, P, PS, R,
     1                  RD, RHO, RHOI, RHOR, V, X)
C
C *** ITERATION DRIVER FOR GENERALIZED (NON)LINEAR MODELS (ETC.)
C
      INTEGER LIV, LV, N, ND, NN, P, PS
      INTEGER IV(LIV), RHOI(*)
      DOUBLE PRECISION B(2,P), D(P), DR(ND,N), R(*), RD(*), RHOR(*),
     1                 V(LV), X(*)
C     DIMENSION RD(N, (P-PS)*(P-PS+1)/2 + 1)
      EXTERNAL RHO
C
C--------------------------  PARAMETER USAGE  --------------------------
C
C B........ BOUNDS ON X.
C D........ SCALE VECTOR.
C DR....... DERIVATIVES OF R AT X.
C IV....... INTEGER VALUES ARRAY.
C LIV...... LENGTH OF IV... LIV MUST BE AT LEAST P + 82.
C LV....... LENGTH OF V...  LV  MUST BE AT LEAST 105 + P*(2*P+16).
C N........ TOTAL NUMBER OF RESIDUALS.
C ND....... LEADING DIMENSION OF DR -- MUST BE AT LEAST PS.
C NN....... LEAD DIMENSION OF R, RD.
C P........ NUMBER OF PARAMETERS (COMPONENTS OF X) BEING ESTIMATED.
C PS....... NUMBER OF NON-NUISANCE PARAMETERS.
C R........ RESIDUALS (OR MEANS -- FUNCTIONS OF X) WHEN DRGLGB IS CALLED
C        WITH IV(1) = 1.
C RD....... TEMPORARY STORAGE.
C RHO...... COMPUTES INFO ABOUT OBJECTIVE FUNCTION.
C RHOI..... PASSED WITHOUT CHANGE TO RHO.
C RHOR..... PASSED WITHOUT CHANGE TO RHO.
C V........ FLOATING-POINT VALUES ARRAY.
C X........ PARAMETER VECTOR BEING ESTIMATED (INPUT = INITIAL GUESS,
C             OUTPUT = BEST VALUE FOUND).
C
C *** CALLING SEQUENCE FOR RHO...
C
C  CALL RHO(NEED, F, N, NF, XN, R, RD, RHOI, RHOR, W)
C
C  PARAMETER DECLARATIONS FOR RHO...
C
C INTEGER NEED(2), N, NF, RHOI(*)
C FLOATING-POINT F, XN(*), R(*), RD(N,*), RHOR(*), W(N)
C
C    RHOI AND RHOR ARE FOR RHO TO USE AS IT SEES FIT.  THEY ARE PASSED
C TO RHO WITHOUT CHANGE.
C    F, R, RD, AND W ARE EXPLAINED BELOW WITH NEED.
C    XN IS THE VECTOR OF NUISANCE PARAMETERS (OF LENGTH P - PS).  IF
C RHO NEEDS TO KNOW THE LENGTH OF XN, THEN THIS LENGTH SHOULD BE
C COMMUNICATED THROUGH RHOI (OR THROUGH COMMON).  RHO SHOULD NOT CHANGE
C XN.
C    NEED(1) = 1 MEANS RHO SHOULD SET F TO THE SUM OF THE LOSS FUNCTION
C VALUES AT THE RESIDUALS R(I).  NF IS THE CURRENT FUNCTION INVOCATION
C COUNT (A VALUE THAT IS INCREMENTED EACH TIME A NEW PARAMETER EXTIMATE
C X IS CONSIDERED).  NEED(2) IS THE VALUE NF HAD AT THE LAST R WHERE
C RHO MIGHT BE CALLED WITH NEED(1) = 2.  IF RHO SAVES INTERMEDIATE
C RESULTS FOR USE IN CALLS WITH NEED(1) = 2, THEN IT CAN USE NF TO TELL
C WHICH INTERMEDIATE RESULTS ARE APPROPRIATE, AND IT CAN SAVE SOME OF
C THESE RESULTS IN R.
C    NEED(1) = 2 MEANS RHO SHOULD SET R(I) TO THE LOSS FUNCTION
C DERIVATIVE WITH RESPECT TO THE RESIDUALS THAT WERE PASSED TO RHO WHEN
C NF HAD THE SAME VALUE IT DOES NOW (AND NEED(1) WAS 1).  RHO SHOULD
C ALSO SET W(I) TO THE APPROXIMATION OF THE SECOND DERIVATIVE OF THE
C LOSS FUNCTION (WITH RESPECT TO THE I-TH RESIDUAL) THAT SHOULD BE USED
C IN THE GAUSS-NEWTON MODEL.  WHEN THERE ARE NUISANCE PARAMETERS (I.E.,
C WHEN PS .LT. P) RHO SHOULD ALSO SET R(I+K*N) TO THE DERIVATIVE OF THE
C LOSS FUNCTION WITH RESPECT TO THE I-TH RESIDUAL AND XN(K), AND IT
C SHOULD SET RD(I,J + K*(K+1)/2 + 1) TO THE SECOND PARTIAL DERIVATIVE
C OF THE I-TH RESIDUAL WITH RESPECT TO XN(J) AND XN(K), 0 .LE. J .LE. K
C AND 1 .LE. K .LE. P - PS, WHERE XN(0) MEANS THE I-TH RESIDUAL ITSELF.
C IN ANY EVENT, RHO SHOULD ALSO SET RD(I,1) TO THE (TRUE) SECOND
C DERIVATIVE OF THE LOSS FUNCTION WITH RESPECT TO THE I-TH RESIDUAL.
C    NF (THE FUNCTION INVOCATION COUNT WHOSE NORMAL USE IS EXPLAINED
C ABOVE) SHOULD NOT BE CHANGED UNLESS RHO CANNOT CARRY OUT THE REQUESTED
C TASK, IN WHICH CASE RHO SHOULD SET NF TO 0.
C
C  ***  GENERAL  ***
C
C     CODED BY DAVID M. GAY.
C
C+++++++++++++++++++++++++++++  DECLARATIONS  ++++++++++++++++++++++++++
C
C  ***  EXTERNAL FUNCTIONS AND SUBROUTINES  ***
C
      EXTERNAL DIVSET, DD7TPR, DD7UP5, DG7ITB,DITSUM, DL7ITV, DL7IVM,
     1        DL7SRT, DL7SQR, DL7SVX, DL7SVN,DL7VML,DO7PRD,
     2         DQ7ADR,DV2AXY,DV7CPY, DV7SCL, DV7SCP, DVSUM
      DOUBLE PRECISION DD7TPR, DL7SVX, DL7SVN, DVSUM
C
C DIVSET.... PROVIDES DEFAULT IV AND V INPUT COMPONENTS.
C DD7TPR... COMPUTES INNER PRODUCT OF TWO VECTORS.
C DD7UP5... UPDATES SCALE VECTOR D.
C DG7ITB... PERFORMS BASIC MINIMIZATION ALGORITHM.
C DITSUM.... PRINTS ITERATION SUMMARY, INFO ABOUT INITIAL AND FINAL X.
C DL7ITV... MULTIPLIES INVERSE TRANSPOSE OF LOWER TRIANGLE TIMES VECTOR.
C DL7IVM... APPLY INVERSE OF COMPACT LOWER TRIANG. MATRIX.
C DL7SRT.... COMPUTES CHOLESKY FACTOR OF (LOWER TRIANG. OF) SYM. MATRIX.
C DL7SQR... COMPUTES L*(L**T) FOR LOWER TRIANG. MATRIX L.
C DL7SVX... UNDERESTIMATES LARGEST SINGULAR VALUE OF TRIANG. MATRIX.
C DL7SVN... OVERESTIMATES SMALLEST SINGULAR VALUE OF TRIANG. MATRIX.
C DL7VML.... COMPUTES L * V, V = VECTOR, L = LOWER TRIANGULAR MATRIX.
C DO7PRD.... ADDS OUTER PRODUCT OF VECTORS TO A MATRIX.
C DQ7ADR... ADDS ROWS TO QR FACTORIZATION.
C DV2AXY.... ADDS A MULTIPLE OF ONE VECTOR TO ANOTHER.
C DV7CPY.... COPIES ONE VECTOR TO ANOTHER.
C DV7SCP... SETS ALL ELEMENTS OF A VECTOR TO A SCALAR.
C DV7SCL... MULTIPLIES A VECTOR BY A SCALAR.
C DVSUM.... RETURNS SUM OF ELEMENTS OF A VECTOR.
C
C  ***  LOCAL VARIABLES  ***
C
      LOGICAL UPDATD, ZEROG
      INTEGER G1, HN1, I, II, IV1, J, J1, JTOL1, K, LH,
     1        NEED1(2), NEED2(2),  PMPS, PS1, PSLEN, QTR1,
     2        RMAT1, STEP1, TEMP1, TEMP2, TEMP3, TEMP4, W, WI, Y1
      DOUBLE PRECISION RHMAX, RHTOL, RHO1, RHO2, T
      integer itmp
      double precision tmp
C
      DOUBLE PRECISION ONE, ZERO
C
C  ***  SUBSCRIPTS FOR IV AND V  ***
C
      INTEGER DINIT, DTYPE, DTINIT, D0INIT, F,
     1        F0, G, HC, IPIVOT, IVNEED, JCN, JTOL, LMAT,
     2        MODE, NEXTIV, NEXTV, NF0, NF1, NFCALL, NFGCAL,
     3        QTR, RDREQ, REGD, RESTOR, RMAT,
     4        RSPTOL, STEP, TOOBIG, VNEED
C
C  ***  IV SUBSCRIPT VALUES  ***
C
      PARAMETER (DTYPE=16, F0=13, G=28, HC=71, IPIVOT=76, IVNEED=3,
     1           JCN=66, JTOL=59, LMAT=42, MODE=35, NEXTIV=46, NEXTV=47,
     2           NFCALL=6, NF0=68, NF1=69, NFGCAL=7, QTR=77, RESTOR=9,
     3           RMAT=78, RDREQ=57, REGD=67, STEP=40, TOOBIG=2, VNEED=4)
C
C  ***  V SUBSCRIPT VALUES  ***
C
      PARAMETER (DINIT=38, DTINIT=39, D0INIT=40, F=10, RSPTOL=49)
      PARAMETER (ONE=1.D+0, ZERO=0.D+0)
      SAVE NEED1, NEED2
      DATA NEED1(1)/1/, NEED1(2)/0/, NEED2(1)/2/, NEED2(2)/0/
C
C+++++++++++++++++++++++++++++++  BODY  ++++++++++++++++++++++++++++++++
C
      LH = P * (P+1) / 2
      IF (IV(1) .EQ. 0) CALL DIVSET(1, IV, LIV, LV, V)
      PS1 = PS + 1
      IV1 = IV(1)
      IF (IV1 .GT. 2) GO TO 10
         W = IV(G) - N
         IV(RESTOR) = 0
         IF (IV(TOOBIG) .EQ. 0) GO TO (110, 120), IV1
         V(F) = V(F0)
         IF (IV1 .NE. 1) IV(1) = 2
         GO TO 40
C
C  ***  FRESH START OR RESTART -- CHECK INPUT INTEGERS  ***
C
 10   IF (ND .LT. PS) GO TO 340
      IF (PS .GT. P) GO TO 340
      IF (PS .LE. 0) GO TO 340
      IF (N .LE. 0) GO TO 340
      IF (IV1 .EQ. 14) GO TO 30
      IF (IV1 .GT. 16) GO TO 360
      IF (IV1 .LT. 12) GO TO 40
      IF (IV1 .EQ. 12) IV(1) = 13
      IF (IV(1) .NE. 13) GO TO 20
      IV(IVNEED) = IV(IVNEED) + P
      IV(VNEED) = IV(VNEED) + P*(P+13)/2 + 2*N + 4*PS
 20   CALL DG7ITB(B, D, X, IV, LIV, LV, P, PS, V, X, X)
      IF (IV(1) .NE. 14) GO TO 999
C
C  ***  STORAGE ALLOCATION  ***
C
      IV(IPIVOT) = IV(NEXTIV)
      IV(NEXTIV) = IV(IPIVOT) + P
      IV(G) = IV(NEXTV) + P + N
      IV(RMAT) = IV(G) + P + 4*PS
      IV(QTR) = IV(RMAT) + LH
      IV(JTOL) = IV(QTR) + P + N
      IV(JCN) = IV(JTOL) + 2*P
      IV(NEXTV) = IV(JCN) + P
C     *** TURN OFF COVARIANCE COMPUTATION ***
      IV(RDREQ) = 0
      IF (IV1 .EQ. 13) GO TO 999
C
 30   JTOL1 = IV(JTOL)
      IF (V(DINIT) .GE. ZERO) CALL DV7SCP(P, D, V(DINIT))
      IF (V(DTINIT) .GT. ZERO) CALL DV7SCP(P, V(JTOL1), V(DTINIT))
      I = JTOL1 + P
      IF (V(D0INIT) .GT. ZERO) CALL DV7SCP(P, V(I), V(D0INIT))
      IV(NF0) = 0
      IV(NF1) = 0
C
 40   G1 = IV(G)
      Y1 = G1 - (P + N)
      CALL DG7ITB(B, D, V(G1), IV, LIV, LV, P, PS, V, X, V(Y1))
      IF (IV(1) - 2) 50, 60, 350
C
 50   V(F) = ZERO
      IF (IV(NF1) .EQ. 0) GO TO 999
      IF (IV(RESTOR) .NE. 2) GO TO 999
      IV(NF0) = IV(NF1)
      CALL DV7CPY(N, RD, R)
      IV(REGD) = 0
      GO TO 999
C
 60   CALL DV7SCP(P, V(G1), ZERO)
      RMAT1 = IABS(IV(RMAT))
      QTR1 = IABS(IV(QTR))
      CALL DV7SCP(PS, V(QTR1), ZERO)
      IV(REGD) = 0
      CALL DV7SCP(PS, V(Y1), ZERO)
      CALL DV7SCP(LH, V(RMAT1), ZERO)
      IF (IV(RESTOR) .NE. 3) GO TO 70
         CALL DV7CPY(N, R, RD)
         IV(NF1) = IV(NF0)
   70 itmp = iv(nfgcal)   
      CALL RHO(NEED2, T, N, itmp, X(PS1), R, RD, RHOI, RHOR,
     $     V(W))
      iv(nfgcal) = itmp
      IF (IV(NFGCAL) .GT. 0) GO TO 90
 80      IV(TOOBIG) = 1
         GO TO 40
 90   IF (IV(MODE) .LT. 0) GO TO 999
      DO 100 I = 1, N
 100     CALL DV2AXY(PS, V(Y1), R(I), DR(1,I), V(Y1))
      GO TO 999
C
C  ***  COMPUTE F(X)  ***
C
 110  I = IV(NFCALL)
      NEED1(2) = IV(NFGCAL)
      tmp = v(f)
      CALL RHO(NEED1, tmp, N, I, X(PS1), R, RD, RHOI, RHOR, V(W))
      v(f) = tmp
      IV(NF1) = I
      IF (I .LE. 0) GO TO 80
      GO TO 40
C
 120  G1 = IV(G)
C
C  ***  DECIDE WHETHER TO UPDATE D BELOW  ***
C
      I = IV(DTYPE)
      UPDATD = .FALSE.
      IF (I .LE. 0) GO TO 130
         IF (I .EQ. 1 .OR. IV(MODE) .LT. 0) UPDATD = .TRUE.
C
C  ***  COMPUTE RMAT AND QTR  ***
C
 130  QTR1 = IABS(IV(QTR))
      RMAT1 = IABS(IV(RMAT))
      IV(RMAT) = RMAT1
      IV(HC) = 0
      IV(NF0) = 0
      IV(NF1) = 0
      IF (IV(MODE) .LT. 0) GO TO 150
C
C  ***  ADJUST Y  ***
C
      Y1 = IV(G) - (P + N)
      WI = W
      STEP1 = IV(STEP)
      DO 140 I = 1, N
         T = V(WI) - RD(I)
         WI = WI + 1
         IF (T .NE. ZERO) CALL DV2AXY(PS, V(Y1),
     1                    T*DD7TPR(PS,V(STEP1),DR(1,I)), DR(1,I), V(Y1))
 140     CONTINUE
C
C  ***  CHECK FOR NEGATIVE W COMPONENTS  ***
C
 150  J1 = W + N - 1
      DO 160 WI = W, J1
         IF (V(WI) .LT. ZERO) GO TO 230
 160     CONTINUE
C
C  ***  W IS NONNEGATIVE.  COMPUTE QR FACTORIZATION  ***
C  ***  AND, IF NECESSARY, USE SEMINORMAL EQUATIONS  ***
C
      RHMAX = ZERO
      RHTOL = V(RSPTOL)
      TEMP1 = G1 + P
      ZEROG = .TRUE.
      WI = W
      DO 190 I = 1, N
         RHO1 = R(I)
         RHO2 = V(WI)
         WI = WI + 1
         T =  SQRT(RHO2)
         IF (RHMAX .LT. RHO2) RHMAX = RHO2
         IF (RHO2 .GT. RHTOL*RHMAX) GO TO 170
C           *** SEMINORMAL EQUATIONS ***
            CALL DV2AXY(PS, V(G1), RHO1, DR(1,I), V(G1))
            RHO1 = ZERO
            ZEROG = .FALSE.
            GO TO 180
 170     RHO1 =  RHO1 / T
C        *** QR ACCUMULATION ***
 180     CALL DV7SCL(PS, V(TEMP1), T, DR(1,I))
         CALL DQ7ADR(PS, V(QTR1), V(RMAT1), V(TEMP1), RHO1)
 190     CONTINUE
C
C  ***  COMPUTE G FROM RMAT AND QTR  ***
C
      TEMP2 = TEMP1 + P
      CALL DL7VML(PS, V(TEMP1), V(RMAT1), V(QTR1))
      IF (ZEROG) GO TO 210
      IV(QTR) = -QTR1
      IF (DL7SVX(PS, V(RMAT1), V(TEMP2), V(TEMP2)) * RHTOL .GE.
     1    DL7SVN(PS, V(RMAT1), V(TEMP2), V(TEMP2))) GO TO 220
         CALL DL7IVM(PS, V(TEMP2), V(RMAT1), V(G1))
C
C        *** SEMINORMAL EQUATIONS CORRECTION OF BJOERCK --
C        *** ONE CYCLE OF ITERATIVE REFINEMENT...
C
         TEMP3 = TEMP2 + PS
         TEMP4 = TEMP3 + PS
         CALL DL7ITV(PS, V(TEMP3), V(RMAT1), V(TEMP2))
         CALL DV7SCP(PS, V(TEMP4), ZERO)
         RHMAX = ZERO
         WI = W
         DO 200 I = 1, N
            RHO2 = V(WI)
            WI = WI + 1
            IF (RHMAX .LT. RHO2) RHMAX = RHO2
            RHO1 = ZERO
            IF (RHO2 .LE. RHTOL*RHMAX) RHO1 = R(I)
            T = RHO1 - RHO2*DD7TPR(PS, V(TEMP3), DR(1,I))
            CALL DV2AXY(PS, V(TEMP4), T, DR(1,I), V(TEMP4))
 200        CONTINUE
         CALL DL7IVM(PS, V(TEMP3), V(RMAT1), V(TEMP4))
         CALL DV2AXY(PS, V(TEMP2), ONE, V(TEMP3), V(TEMP2))
         CALL DV2AXY(PS, V(QTR1), ONE, V(TEMP2), V(QTR1))
 210     IV(QTR) = QTR1
 220  CALL DV2AXY(PS, V(G1), ONE, V(TEMP1), V(G1))
      IF (PS .GE. P) GO TO 330
      GO TO 250
C
C  ***  INDEFINITE GN HESSIAN...  ***
C
 230  IV(RMAT) = -RMAT1
      IV(HC) = RMAT1
      CALL DO7PRD(N, LH, PS, V(RMAT1), V(W), DR, DR)
C
C  ***  COMPUTE GRADIENT  ***
C
      G1 = IV(G)
      DO 240 I = 1, N
 240     CALL DV2AXY(PS, V(G1), R(I), DR(1,I), V(G1))
      IF (PS .GE. P) GO TO 330
C
C  ***  COMPUTE GRADIENT COMPONENTS OF NUISANCE PARAMETERS ***
C
 250  K = P - PS
      J1 = 1
      G1 = G1 + PS
      DO 260 J = 1, K
         J1 = J1 + NN
         V(G1) = DVSUM(N, R(J1))
         G1 = G1 + 1
 260     CONTINUE
C
C  ***  COMPUTE HESSIAN COMPONENTS OF NUISANCE PARAMETERS  ***
C
      I = PS*PS1/2
      PSLEN = P*(P+1)/2 - I
      HN1 = RMAT1 + I
      CALL DV7SCP(PSLEN, V(HN1), ZERO)
      PMPS = P - PS
      K = HN1
      J1 = 1
      DO 290 II = 1, PMPS
         J1 = J1 + NN
         J = J1
         DO 270 I = 1, N
            CALL DV2AXY(PS, V(K), RD(J), DR(1,I), V(K))
            J = J + 1
 270        CONTINUE
         K = K + PS
         DO 280 I = 1, II
            J1 = J1 + NN
            V(K) = DVSUM(N, RD(J1))
            K = K + 1
 280        CONTINUE
 290     CONTINUE
      IF (IV(RMAT) .LE. 0) GO TO 330
      J = IV(LMAT)
      CALL DV7CPY(PSLEN, V(J), V(HN1))
      IF (DL7SVN(PS, V(RMAT1), V(TEMP2), V(TEMP2)) .LE. ZERO) GO TO 300
      CALL DL7SRT(PS1, P, V(RMAT1), V(RMAT1), I)
      IF (I .LE. 0) GO TO 310
C
C  *** HESSIAN IS NOT POSITIVE DEFINITE ***
C
 300  CALL DL7SQR(PS, V(RMAT1), V(RMAT1))
      CALL DV7CPY(PSLEN, V(HN1), V(J))
      IV(HC) = RMAT1
      IV(RMAT) = -RMAT1
      GO TO 330
C
C  *** NUISANCE PARS LEAVE HESSIAN POS. DEF.  GET REST OF QTR ***
C
 310  J = QTR1 + PS
      G1 = IV(G) + PS
      DO 320 I = PS1, P
         T = DD7TPR(I-1, V(HN1), V(QTR1))
         HN1 = HN1 + I
         V(J) = (V(G1) - T) / V(HN1-1)
         J = J + 1
         G1 = G1 + 1
 320     CONTINUE
 330  IF (UPDATD) CALL DD7UP5(D, IV, LIV, LV, P, PS, V)
      GO TO 40
C
C  ***  MISC. DETAILS  ***
C
C     ***  BAD N, ND, OR P  ***
C
 340  IV(1) = 66
      GO TO 360
C
C  ***  PRINT SUMMARY OF FINAL ITERATION AND OTHER REQUESTED ITEMS  ***
C
 350  G1 = IV(G)
 360  CALL DITSUM(D, V(G1), IV, LIV, LV, P, V, X)
c 360  CONTINUE
C
 999  RETURN
C  ***  LAST LINE OF DRGLGB FOLLOWS  ***
      END
