#!/bin/sh

#  gjdocxml2html.sh
#  Copyright (C) 2001 Free Software Foundation, Inc.
#  
#  This file is part of GNU Classpath.
#  
#  GNU Classpath is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.
#   
#  GNU Classpath is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.
#  
#  You should have received a copy of the GNU General Public License
#  along with GNU Classpath; see the file COPYING.  If not, write to the
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
#  02111-1307 USA.


#
#  Convenience script for using gjdocxml2html.xsl to process a
#  Java documentation XML file produced by
#  gnu.classpath.tools.doclets.xmldoclet.Driver
#
#  USAGE: gjdocxml2html <input-file> <target-directory>
#

if [ $# != 2 ]; then
    echo "USAGE: gjdocxml2html <source-directory> <target-directory>"
    exit 5
fi

# Check arguments

if [ ! -d $1 ]; then
    echo "Source directory does not exist."
    exit 5
fi

if [ ! -d $2 ]; then
    echo "Target directory does not exist."
    exit 5
fi

# Copy common files - CSS sheets, images etc.

echo "Copying common files..."
cp -Ru xslt/common $2

# Create a local catalog for accelerating lookup of external entities
# NOTE: For development purposes only. This should move to the Makefile
# and be executed once on installation.

xmlcatalog --noout --create \
	   --add "public" \
	       "-//GNU//DTD Gjdoc XML V0.1.1//EN" \
	       http://www.gnu.org/software/cp-tools/dtd/gjdoc.dtd \
	   --add "rewriteSystem" \
	       http://www.gnu.org/software/cp-tools/dtd/ \
	       file:///usr/local/share/gjdoc/dtd/ \
	   gjdoccatalog.xml 

# Add the local catalog to the catalog search path

export SGML_CATALOG_FILES="$SGML_CATALOG_FILES gjdoccatalog.xml"

# Start the xslt process

xsltproc \
    --catalogs \
    --param verbose "1" \
    --param now "'`date`'" \
    --param copyrightfile "'../classpath-copyright.xml'" \
    --param windowtitle "'GNU Classpath 0.04'" \
    --param targetdir "'$2'" \
    xslt/gjdocxml2html.xsl \
    $1/index.xml \
    $3 $4 $5 $6 $7 $8 $9
