#!/usr/bin/env python

# Directory Notifier code Originally by Keith Dart, available at:
# http://aspn.activestate.com/ASPN/Cookbook/Python/Recipe/217829
# All other stuff by Gabe Ginorio and Alberto Fornasier (2004)
# As a note : The copius comments are as much for me as for anyone else

################################################################
# DirectoryNotifier encapsulates the code required for watching
# directory entry contents. Subclass this and override the entry_added()
# and entry_removed() methods. then, instantiate it with a directory
# name, and register it with the sighandler instance.  NOTE: this only
# works with Python 2.2 or greater on Linux. Example:
#	notifier = file_monitor.create(args)
#	signal.signal(signal.SIGIO, lambda sig, frame: notifier(frame))
################################################################


import os, fcntl, signal, stat, time
import mimetype

MONITORED_FILES = {}

def create(calling_class, current_location, is_listing):
	''' This functions opens a file descriptor for a passed directory, sets the SIGIO
	signal on the directory then sets the type of SIGIO signals to catch.'''

	# If we are listing, do nothing
	if is_listing == True:
		return 0

	# Open a file descriptor
	file_descriptor = os.open(current_location, 0)

	# Get the old signal and set the signal of the directory to notify
	old_signal = fcntl.fcntl(file_descriptor, fcntl.F_GETSIG)
	fcntl.fcntl(file_descriptor, fcntl.F_SETSIG, 0)

	# Catch only the signals we want
	fcntl.fcntl(file_descriptor, fcntl.F_NOTIFY, fcntl.DN_DELETE|fcntl.DN_CREATE|fcntl.DN_RENAME|fcntl.DN_MULTISHOT)

	# Possible signals: DN_MODIFY, DN_DELETE, DN_CREATE, DN_RENAME, DN_ATTRIB, DN_MULTISHOT

	MONITORED_FILES[file_descriptor] = [calling_class, os.listdir(current_location), current_location, old_signal]
	
	#The  sets the SIGIO callback
	signal.signal(signal.SIGIO, lambda sig, frame: __sigioCallback__(frame))
	
	return file_descriptor


def delete(file_descriptor):
	'''This funtion is called to reset the signal on a folder from SIGIO to
	whatever it was before F_NOTIFY was set.'''

	if file_descriptor in MONITORED_FILES:
		old_signal = MONITORED_FILES[file_descriptor][3]

		fcntl.fcntl(file_descriptor, fcntl.F_SETSIG, old_signal)
		os.close(file_descriptor)
		del MONITORED_FILES[file_descriptor]


def __sigioCallback__(frame):
	'''This function is called with the class is called like a function "monitor_class(arg)":
	signal.signal(signal.SIGIO, lambda sig, frame: monitor(frame))
	The frames (commands in the SIGIO queue) are passed to this class.'''

	for file_descriptor in MONITORED_FILES:

		calling_class = MONITORED_FILES[file_descriptor][0]
		old_file_list = MONITORED_FILES[file_descriptor][1]
		location = MONITORED_FILES[file_descriptor][2]
		
		# See if the directory has just changed
		if os.stat(location)[stat.ST_MTIME]  == int(time.time()):

			# Get the contents of the current directory and the contents before the change
			new_file_list = os.listdir(location)
			changed = False
			
			added 	= filter(lambda a_file: a_file not in old_file_list , new_file_list)
			removed	= filter(lambda a_file: a_file not in new_file_list , old_file_list)

			if added != []:
				for a_file in added:
					current_location = location + "/" + a_file

					if calling_class.tab.view == "icon":
						# Update the mimetypes
						new_mimetype = mimetype.getTypes(None, current_location)[current_location]
						eventbox, label = calling_class.__createIcon__(current_location, new_mimetype)

						# Update the icon and label lists
						calling_class.icons[current_location] = eventbox
						calling_class.labels[current_location] = label
					changed = True

			if removed != []:
				for a_file in removed:
					current_location = location + "/" + a_file
					
					if calling_class.tab.view == "icon":					
						# Remove the icons from the layout
						calling_class.main_layout.remove(calling_class.icons[current_location])
						calling_class.main_layout.remove(calling_class.labels[current_location])

						# Delete the locations and widgets
						calling_class.locations.remove(current_location)
						del calling_class.icons[current_location]
						del calling_class.labels[current_location]
					changed = True

			# Set the new directory list and re-list the icons in the layout
			if changed:	
				calling_class.locations = calling_class.tab.__organizeContents__(location)
				MONITORED_FILES[file_descriptor][1] = os.listdir(location)
				if calling_class.tab.view == "icon":		
					calling_class.__placeIcons__()
				else:
					calling_class.__populate__()
