# just checking your version of Perl does not barf when seeing this

# Copyright (c) 2007 Claudio Calvelli, all rights reserved.

# CLC-INTERCAL is copyrighted software. However, permission to use, modify,
# and distribute it is granted provided that the conditions set out in the
# licence agreement are met. See files README and COPYING in the distribution.

open(MANIFEST, 'MANIFEST') or do { print "1..0\n"; exit };

my %interface_uses = (
    X => 'Gtk2',
    Curses => 'Curses',
    Line => 'Term::ReadLine',
);

my @module_tests = ();
my @script_tests = ();
while (<MANIFEST>) {
    chomp;
    my $orig = $_;
    m#^(INTERCAL/\S+)\.pm\s*(\S+)$# and do {
	my ($mod, $perv) = ($1, $2);
	if ($mod =~ /Interface\/(.*$)/ && exists $interface_uses{$1}) {
	    eval "require $interface_uses{$1}";
	    next if $@;
	}
	$orig =~ s/\s+\S+$//;
	push @module_tests, [$mod, $perv, $orig];
    };
    m#^bin/(\S+)\s*(\S+)$#
	and push @script_tests, [$1, $2];
}

$| = 1;
my $testno = 2 * (@module_tests + @script_tests);

print "1..$testno\n";

my $exit = 0;
$testno = 1;
for my $m (@module_tests) {
    my ($mfile, $perv, $ofile) = @$m;
    my $mname = $mfile;
    $mname =~ s#/+#::#g;
    $mname =~ s#^/*#Language::#;
    mtest($testno, $mname, $perv, $mfile, $ofile);
    $testno += 2;
}

for my $s (@script_tests) {
    my ($sfile, $perv) = @$s;
    stest($testno, $sfile, $perv);
    $testno += 2;
}

exit $exit;

sub etest {
    my ($test, $eval) = @_;
    eval $eval;
    if ($@) {
	print STDERR "$eval:\n$@";
	print 'not ';
	$exit = 1;
    }
    print "ok $test\n";
}

sub mtest {
    my ($test, $module, $perv, $mfile, $ofile) = @_;
    etest($test, "use $module $perv");
    etest($test + 1, "defined \$${module}::PERVERSION &&
		      \$${module}::PERVERSION eq
		      'CLC-INTERCAL $ofile $perv' or
		      die(\"PerVersion string mismatch\\n\")");
}

sub stest {
    my ($test, $script, $perv) = @_;
    my $src = -f "blib/script/$script" ? "blib/script/$script" : "bin/$script";
    if (open(SCRIPT, '<', $src)) {
	my $text = '';
	my $pervcode = undef;
	while (<SCRIPT>) {
	    last if /^__(?:END|DATA)__$/;
	    $text .= $_;
	    next if defined $pervcode || ! /PERVERSION\s*=/;
	    chomp;
	    $pervcode = $_;
	}
	close SCRIPT;
	eval "local \$^W = 0; no strict; no warnings; sub SUB$test { $text }";
	if ($@) {
	    print STDERR $@;
	    print "not ok ", $test++, "\n";
	    print "not ok ", $test++, "\n";
	} else {
	    undef &{"SUB$test"};
	    print "ok ", $test++, "\n";
	    if (defined $pervcode) {
		my $perversion = eval "$pervcode; \$PERVERSION";
		if ($@) {
		    print STDERR $@;
		    print "not ok ", $test++, "\n";
		} elsif ( $perversion eq "CLC-INTERCAL bin/$script $perv") {
		    print "ok ", $test++, "\n";
		} else {
		    print STDERR "Perversion string mismatch ($perversion)\n";
		    print "not ok ", $test++, "\n";
		}
	    } else {
		print "not ok ", $test++, "\n";
	    }
	}
    } else {
	print "not ok ", $test++, "\n";
	print "not ok ", $test++, "\n";
    }
}

