/*
*
* cobex_core.h - Core library for OBEX-over-cable 
*
* Copyright (c) 2003,2004,2005,2006 Fredrik Srensson
*
* History:
* v0.2 - fsn - 03-08-24 - First version
* v0.3 - fsn - 04-07-08 - Added the header parser
* v0.4 - fsn - 05-01-31 - Renamed everything
* v0.5 - fsn - 06-09-24 - National Character support
*
* Source:
*
*/

#include <sys/types.h>
#include "cobex_defs.h"

#ifndef __COBEX_CORE_H
#define __COBEX_CORE_H

#define COBEX_OK 			0
#define COBEX_ERR			-1
#define COBEX_ERR_BUFFER_OVERFLOW	-2
#define COBEX_ERR_TIMEOUT		-3
#define COBEX_ERR2			-5

#define MAXCHARS			256

typedef struct {
	u_int max;
	u_int l;
	u_char *buffer;
} obex_packet;

typedef struct {
	u_char HI;			// The actual HeaderIdentifier
	u_int HIlen;			// The length of the data (ie. without 3bytes header)
	u_char *HIdata;			// a hard pointer to the data
	u_int nextHIp;			// Next headerposition or 0.
} parsedData;

// obex_packet building functions

int obex_opcode_connect		( obex_packet *inPacket );
int obex_opcode_disconnect	( obex_packet *inPacket );
int obex_opcode_put		( obex_packet *inPacket );
int obex_opcode_abort		( obex_packet *inPacket );
int obex_opcode_setpath 	( obex_packet *inPacket, char flags);
int obex_opcode_get 		( obex_packet *inPacket );

int obex_hi_name3 		( obex_packet *inPacket, char *msg, int lgt );
int obex_hi_name2 		( obex_packet *inPacket, char *msg, int lgt );
int obex_hi_name		( obex_packet *inPacket, char *msg, int lgt );
int obex_hi_body		( obex_packet *inPacket, char *data, int dataLgt, int dataStart );
int obex_hi_endofbody		( obex_packet *inPacket );
int obex_hi_target 		( obex_packet *inPacket, char *msg, int lgt );
int obex_hi_type 		( obex_packet *inPacket, char *msg, int lgt );
int obex_hi_connection_id 	( obex_packet *inPacket, char *msg );
// I hope that forever and ever an u_int will always be at least four bytes. Right?
int obex_hi_length		( obex_packet *inPacket, u_int length );

int cobex_packlgt		( obex_packet *inPacket );
int cobex_set_final_bit		( obex_packet *inPacket );

// Packet parsing

int cobex_parseStart 		( obex_packet *inPacket );
parsedData cobex_parseNext 	( obex_packet *inPacket, u_int p);
int cobex_response_code 	( obex_packet *inPacket );

// Debug stuff

void cobex_packet_dump		( obex_packet *inPacket );

// Error handling

char *cobex_respstring		( int respno );

// Isn't there like a standard Integer min function ANYWHERE??

int imin ( int a, int b);

#endif

