/*
*
* get.c - COBEX - Get a file from a device.
*
* Copyright 2003,2004,2005,2006 Fredrik Srensson
*
* History:
* v0.5 - fsn - 04-02-22 - First version
* v0.6 - fsn - 05-07-19 - Using general signal handling and general path handling
* v0.7 - fsn - 06-07-29 - Code cleanup
*
* Source:
*
*/

#include <stdio.h>
#include <ezV24/ezV24.h>
#include <signal.h>
#include <string.h>

#include "cobex_core.h"
#include "cobex_tools.h"
#include "cobex_serial.h"

void help () {
	printf ("cobex_get v0.6\n\n");
	printf ("Usage: cobex_get <device> <filename>\n\n");
	printf ("All arguments are compulsory and order is important. Writes to stdout.\n\n");
}

// Main routine

int main (int argc, char *argv[]) {
	v24_port_t *UsedPort=NULL;
	int rc;
	char aBuffer[513];
	obex_packet aPacket;
	char *name;
	char *path;
	char *target;

	aPacket.max=512;
	aPacket.buffer=aBuffer;
	

	if (argc != 3) {
		printf ("ERR: Wrong argc : %d.\n",argc);
		help();
		return 1;
	}

	target = ctools_determineTarget(argv[2]);

	// Set up the port

	rc = ctools_commonInit( &UsedPort, &aPacket, argv[1], target );
	if (rc != COBEX_OK) { exit (COBEX_ERR); }	

	// Do the specific things

	path = calloc( strlen(argv[2])+1, sizeof(char) );
	name = calloc( strlen(argv[2])+1, sizeof(char) );
	
	ctools_buildPath ( argv[2], path, name );	
	rc=ctools_recursePath( &aPacket, path, UsedPort, OBEX_SETPATH_DONTCREATE );
	rc=ctools_getFileByName( &aPacket, name, UsedPort );
		
	if (cobex_response_code(&aPacket) != (OBEX_RESPONSE_OK|OBEX_FINAL_BIT) ) { 
		fprintf (stderr, "ERR: %s \n",
			cobex_respstring(cobex_response_code(&aPacket)) ) ;
		ctools_abort( &aPacket, UsedPort );			// Really? I need to think about this one.
		rc=COBEX_ERR;
	}

	// Bye, y'all!

	free (path);
	free (name);
	ctools_disconnect( &aPacket, UsedPort );	
	cobex_closePort(UsedPort);
	
	return rc;

}

