dofile(input.find_file(instance,"luat-log.lua"))

texmf.instance = instance -- we need to get rid of this / maybe current instance in global table

scripts       = scripts       or { }
scripts.chars = scripts.chars or { }

function scripts.chars.stixtomkiv(inname,outname)
    if inname == "" then
        logs.report("aquiring math data","invalid datafilename")
    end
    local f = io.open(inname)
    if not f then
        logs.report("aquiring math data","invalid datafile")
    else
        logs.report("aquiring math data","processing " .. inname)
        if not outname or outname == "" then
            outname = "char-mth.lua"
        end
        local classes = {
            N = "normal",
            A = "alphabetic",
            D = "diacritic",
            P = "punctuation",
            B = "binary",
            R = "relation",
            L = "large",
            O = "opening",
            C = "closing",
            F = "fence"
        }
        local format, concat = string.format, table.concat
        local valid, done = false, { }
        local g = io.open(outname,'w')
        g:write([[
-- filename : char-mth.lua
-- comment  : companion to char-mth.tex (in ConTeXt)
-- author   : Hans Hagen, PRAGMA-ADE, Hasselt NL
-- license  : see context related readme files
-- comment  : generated from data file downloaded from STIX website

if not versions   then versions   = { } end versions['char-mth'] = 1.001
if not characters then characters = { } end
        ]])
        g:write(format("\ncharacters.math = {\n"))
        for l in f:lines() do
            if not valid then
                valid = l:find("AMS/TeX name")
            end
            if valid then
                local unicode = l:sub(2,6)
                if unicode:sub(1,1) ~= " " and unicode ~= "" and not done[unicode] then
                    local mathclass, adobename, texname = l:sub(57,57) or "", l:sub(13,36) or "", l:sub(84,109) or ""
                    texname, adobename = texname:gsub("[\\ ]",""), adobename:gsub("[\\ ]","")
                    local t = { }
                    if mathclass ~= "" then t[#t+1] = format("mathclass='%s'", classes[mathclass] or "unknown") end
                    if adobename ~= "" then t[#t+1] = format("adobename='%s'", adobename                      ) end
                    if texname   ~= "" then t[#t+1] = format("texname='%s'"  , texname                        ) end
                    if #t > 0 then
                        g:write(format("\t[0x%s] = { %s },\n",unicode, concat(t,", ")))
                    end
                    done[unicode] = true
                end
            end
        end
        if not valid then
            g:write("\t-- The data file is corrupt, invalid or maybe the format has changed.\n")
            logs.report("aquiring math data","problems with data table")
        else
            logs.report("aquiring math data","table saved in " .. outname)
        end
        g:write("}\n")
        g:close()
        f:close()
    end
end

scripts.chars.banner_utf_1 = [[
% filename : enco-utf.tex
% comment  : generated by mtxrun --script chars --utf
% author   : Hans Hagen, PRAGMA-ADE, Hasselt NL
% copyright: PRAGMA ADE / ConTeXt Development Team
% license  : see context related readme files

\ifx\setcclcucx\undefined

  \def\setcclcucx #1 #2 #3 %
    {\global\catcode"#1=11
     \global\lccode "#1="#2
     \global\uccode "#1="#3 }

\fi
]]

scripts.chars.banner_utf_2 = [[

% lc/uc/catcode mappings

]]

scripts.chars.banner_utf_3 = [[

% named characters mapped onto utf

]]

scripts.chars.banner_utf_4 = [[

\endinput
]]

function scripts.chars.makeencoutf()
    local chartable = input.find_file(instance,"char-def.lua") or ""
    if chartable ~= "" then
        dofile(chartable)
        if characters and characters.data then
            local f = io.open("enco-utf.tex", 'w')
            if f then
                local char, format = unicode.utf8.char, string.format
                f:write(scripts.chars.banner_utf_1)
                f:write(scripts.chars.banner_utf_2)
                local list = table.sortedkeys(characters.data)
                local length = 0
                for i=1,#list do
                    local code = list[i]
                    if code <= 0xFFFF then
                        local chr = characters.data[code]
                        local cc = chr.category
                        if cc == 'll' or cc == 'lu' or cc == 'lt' then
                            if not chr.lccode then chr.lccode = code end
                            if not chr.uccode then chr.uccode = code end
                            f:write(format("\\setcclcucx %04X %04X %04X %% %s\n",code,chr.lccode,chr.uccode,chr.description))
                        end
                        if #(chr.contextname or "") > length then
                            length = #chr.contextname
                        end
                    end
                end
                f:write(scripts.chars.banner_utf_3)
                for i=1,#list do
                    local code = list[i]
                    if code > 0x7F and code <= 0xFFFF then
                        local chr = characters.data[code]
                        if chr.contextname then
                            f:write(format("\\def\\%s{%s} %% %s\n", chr.contextname:rpadd(length," "), char(code),chr.description))
                        end
                    end
                end
                f:write(scripts.chars.banner_utf_4)
                f:close()
            end
        end
    end
end

banner = banner .. " | character tools "

messages.help = [[
--stix                convert stix table to math table
--utf                 generate enco-utf.tex (used by xetex)
]]

if environment.argument("stix") then
    local inname  = environment.files[1] or ""
    local outname = environment.files[2] or ""
    scripts.chars.stixtomkiv(inname,outname)
elseif environment.argument("utf") then
    scripts.chars.makeencoutf()
else
    input.help(banner,messages.help)
end
