/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#ifndef _CERTIFICATE_VIEWER_HH
#define _CERTIFICATE_VIEWER_HH

#include <wx/wx.h>
#include <wx/treectrl.h>
#include <wx/listctrl.h>
//#include <wx/generic/listctrl.h>


#include "CryptonitDlg.hh"
#include "../Certificate.hh"
#include "../User.hh"

using namespace Cryptonit ;
class CertificateViewer: public CryptonitDlg
{
public:
    
      
    /** 
     * Frame displaying informations about a certificate
     * 
     * @param parent : parent window
     * @param id : an id identifying this frame
     * @param title : a title
     * @param pos : position
     * @param size : size of the frame
     * @param style 
     * @param name 
     */
    CertificateViewer(wxWindow* parent, 
		      wxWindowID id, 
		      const wxString& title, 
		      const bool dislayCRL = false);


    

    CertificateViewer(const Certificate &_certif, User *u,
		      wxWindow* parent, 
		      wxWindowID id, 
		      const wxString& title, 
		      const bool dislayCRL = false);
    
    
    ~CertificateViewer();
private:    
    void createGeneralPage(wxWindow* parent, wxPanel** panel);
    
    void createDetailsPage(wxWindow* parent, wxPanel** panel);

    void createCertificationPathPage(wxWindow* parent, wxPanel** panel);

    wxPanel* createCRLPage();
    
    
      
    void viewCert(wxCommandEvent &WXUNUSED(event));
    void viewCert2(wxTreeEvent &WXUNUSED(event));
    void checkCert(wxTreeEvent &WXUNUSED(event));
    
    
    void fillCrlList();
    void onAddCrl(wxCommandEvent &WXUNUSED(event));
    void onDelCrl(wxCommandEvent &WXUNUSED(event));
    void onSelectCrl(wxListEvent &event);
    void onUpdateCrl(wxCommandEvent &WXUNUSED(event));
    bool deleteCrl(wxListItem selectedItem);
    bool saveCrl(Crl *crl, wxString uri);
    void saveCrlErrorHandler( int error );
    void clearListData();
    void displayCrlInfo( wxString crlFile );
    

    wxString fetchCrl(wxString uri);

    Certificate *certif;

    wxNotebook *tab;
    wxButton *openViewerBtn ;
    wxTreeCtrl *certificationTree;
    std::vector<Certificate> *vect;
    
    //wxTextCtrl *crl;
    wxListCtrl *crlList;
    
    //wxStaticText *crlIssuer;
    wxStaticText *crlVersion;
    wxStaticText *crlLastUpdate;
    wxStaticText *crlNextUpdate;
    wxButton *crlAdd;
    wxButton *crlDelete;
    wxButton *uriUpdate;
    wxStaticText *crlUri;

    User *user;
    
    std::vector<std::string> crlVector;
    

    DECLARE_EVENT_TABLE() 
};


class CertificateTreeItem : public wxTreeItemData{
    
public:    
    CertificateTreeItem(const Certificate &cert);
    Certificate &getCert();

private: 
    Certificate c;

};


enum
    { 
	CV_VIEW_BTN_ID= 9000,
	CV_CERT_TREE_ID,
	CV_CRL_ID,
	CV_CRLLIST_ID,
	CV_CRLADD_ID,
	CV_CRLDEL_ID,
	CV_URI_BTN_ID
    };


#endif
