/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */
#ifndef _NEW_USER_WIZARD_hh_
#define _NEW_USER_WIZARD_hh_

#include <wx/wx.h>
#include <wx/wizard.h>

#include "../User.hh"
#include "../pkcs12.hh"

#include "Cryptonit.hh"
DECLARE_APP(CryptonitGui)

using namespace Cryptonit;

#ifndef USER_AUTHENTICATION

#define USER_NAME "default"
#define USER_PASSWD "emiliano"

#endif

class NewUserWizard: public wxWizard
{

private:

    wxWizard* wizard;
    
    class LoginName: public wxWizardPageSimple
    {
    private:
	NewUserWizard* myParent;

	void onWizardPageChanging(wxWizardEvent& event);
	void onCancel(wxWizardEvent& event);
	
	DECLARE_EVENT_TABLE();

    public:
	wxTextCtrl* tcLoginName;
	wxTextCtrl* tcPassword;
	wxComboBox* cbLanguage;
	LoginName(wxWizard* parent);

    };


    class ImportMethod: public wxWizardPageSimple
    {
    private:
	NewUserWizard* myParent;
	LoginName *loginPage ;
	
	wxRadioButton* blankAccount;
	wxRadioButton* rbPkcs12;
	wxRadioButton* rbCertificateRequest;

	wxString p12Filename;
	pkcs12 *p12;

	void onWizardPageChanging(wxWizardEvent& event);
	void onCancel(wxWizardEvent& event);
	
	DECLARE_EVENT_TABLE();

    public:
	std::string *identity;
	enum importMethod { PKCS12, REQUEST, BLANK };
	importMethod method;
	std::string *filename;
	ImportMethod(wxWizard* parent, LoginName *ln);
    };


    
    class Summary: public wxWizardPageSimple
    {
    private:
	NewUserWizard* myParent;
	LoginName *loginPage ;
	ImportMethod *imPage;
	
	
	void onWizardPageChanging(wxWizardEvent& event);
	void onWizardPageChanged(wxWizardEvent& event);
	void onCancel(wxWizardEvent& event);
	
	DECLARE_EVENT_TABLE();

    public:
	Summary(wxWizard* parent, LoginName *ln ,ImportMethod *im);
    };
    
    
    DECLARE_EVENT_TABLE();

public:
    LoginName* loginName;
    ImportMethod* importMethod;
    Summary* summary;

    wxString newUserLogin;

    NewUserWizard( wxWindow* parent );
    ~NewUserWizard();

    void onCancel(wxWizardEvent& event);

    wxString getNewUserLogin();
    static bool createUserFiles(wxString login , wxString password, wxString lang);
};

enum {
    NUW_PKCS12_RADIO_ID = 7600,
    NUW_CERTIFICATE_REQUEST_RADIO_ID
};

#endif
