/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#include <wx/wx.h>
#include <wx/dir.h>
#include <wx/filename.h>

#ifndef __WXMSW__ // en attendant
#include "pics/password.xpm"
#endif

#include "Common.hh"
#include "PasswordDlg.hh"
#include "CertificateViewer.hh"

BEGIN_EVENT_TABLE (PasswordDlg, CryptonitDlg)
    EVT_BUTTON (PDLG_CV_BTN , PasswordDlg::onCVBtn)
END_EVENT_TABLE()


PasswordDlg::PasswordDlg(wxWindow *parent, wxWindowID id,
			 const wxString &title,
			 const wxString &label, User *u, dialogType type,
			 const wxString &certLabel)
    : CryptonitDlg(parent, id, title)
{

    user = u;
    keyCombo = NULL;
  
    passwordField = new wxTextCtrl(this, -1, wxEmptyString, wxDefaultPosition, wxSize(200,22), wxTE_PASSWORD);

    //s = size;
    wxBoxSizer *sizer = new wxBoxSizer(wxHORIZONTAL);
    wxBitmap bitmap = wxBITMAP(password);
#ifdef __WXMSW__
    bitmap.SetMask( new wxMask(bitmap, wxColour(0xC0,0xC0,0xC0)) );
#endif
    wxStaticBitmap *icon = new wxStaticBitmap(this, -1, bitmap);
    
    wxBoxSizer *passSizer = new wxBoxSizer(wxVERTICAL);
    
    if( type == PDLG_KEY_SIGN || type ==  PDLG_KEY_ALL ){
	passSizer->Add( new wxStaticText( this, -1, _("Choose your private key.") ),
			0,                         // make vertically unstretchable
			wxALIGN_CENTER |            // right align text
			wxTOP | wxLEFT | wxRIGHT,  // make border all around except wxBOTTOM
			5 );                      // set border width to 5
	
      
	keyCombo = new wxComboBox(this, -1 , _T(""), wxDefaultPosition, 
				  wxSize(300,20), 0 , NULL, wxCB_READONLY);
      
	populateKeyCombo(type);
      
	passSizer->Add(keyCombo, 0,wxEXPAND| wxCENTER |wxALL,5);
    }
  
  
  
    passSizer->Add( new wxStaticText( this, -1, label),
		    0,                         // make vertically unstretchable
		    wxALIGN_CENTER | wxALIGN_CENTER_VERTICAL |            // right align text
		    wxTOP | wxLEFT | wxRIGHT,  // make border all around except wxBOTTOM
		    5 );                      // set border width to 5

    if( type == PDLG_KEY_DECRYPT) {
	wxStaticText *certLabelText = new wxStaticText( this , -1 , certLabel);
	wxFont font = certLabelText->GetFont();
	font.SetWeight(wxBOLD);
	certLabelText->SetFont( font );
	
	passSizer->Add( certLabelText,
			0,                         // make vertically unstretchable
			wxALIGN_CENTER | wxALIGN_CENTER_VERTICAL |            // right align text
			wxTOP | wxLEFT | wxRIGHT,  // make border all around except wxBOTTOM
			5 );                      // set border width to 5
    }

    passSizer->Add(passwordField, 0,wxEXPAND| wxCENTER |wxALL| wxALIGN_CENTER_VERTICAL,5);
    
    sizer->Add(icon, 0 ,wxEXPAND | wxALIGN_CENTER_VERTICAL  | wxALL , 10);
    sizer->Add(passSizer, 1 , wxEXPAND |wxCENTER |wxALL,5);
    mainSizer->Add(sizer, 1 , wxEXPAND |wxCENTER |wxALL, 5);
}


PasswordDlg::~PasswordDlg()
{
    if( keyCombo != NULL ) {
	for( int i=0 ; i < keyCombo->GetCount() ; i++ ) {
	    std::string *data = (std::string *)keyCombo->GetClientData( i );
	    if( data ) {
		delete  data ;
	    }
	}
    }
}



void PasswordDlg::populateKeyCombo(int type)
{
    if( user != NULL ) {
	wxDir dir(wxGetCwd());
	wxArrayString filename;
	
	wxFileName p12Dir( std2wx(user->getP12Dir()) );
	
	dir.GetAllFiles(p12Dir.GetFullPath(), &filename, wxEmptyString, wxDIR_FILES);

	unsigned int i;
	for(i=0; i<filename.GetCount();i++){
	    std::string *data = new std::string( wx2std(wxFileName(filename.Item(i)).GetFullName()) );
	    std::string certName = wx2std(wxFileName(filename.Item(i)).GetFullName());

	    certName = certName.substr(0 , certName.size() - 4);
	    wxFileName certFilename(std2wx(certName));
	    certFilename.SetExt( _T("der") );
	    certFilename=wxMyPrepend(certFilename, std2wx(user->getCertificatesDir()) );

	    Certificate c;
	    c.load(wx2std(certFilename.GetFullPath()).c_str());

	    std::string keyName = c.getSubjectName().getValues(DN_DISPLAY_SHORT | DN_DISPLAY_VALUE , ',');

	    keyCombo->Append( std2wx(keyName) );	   
	    keyCombo->SetClientData( i, (void *)data );
	}
    }
}


wxString PasswordDlg::getPassword()
{
    return passwordField->GetValue();
}


wxString PasswordDlg::getKey()
{
    std::string *hash = (std::string *)keyCombo->GetClientData(keyCombo->GetSelection());
    if(hash) {
				return std2wx(*hash);
    }
    return _T("");
}


void PasswordDlg::addButtons()
{
    okBtn = new wxButton(this,wxID_OK,_("OK"));
    okBtn->SetDefault();
    
    cancelBtn = new wxButton(this,wxID_CANCEL,_("Cancel"));
    
    btnSizer->Add(cancelBtn, 0, wxALIGN_CENTER | wxALL,	 6);  
    btnSizer->Add(okBtn, 0,wxALIGN_CENTER |wxALL,6);

    mainSizer->Add(btnSizer, 0 , wxALIGN_BOTTOM | wxALIGN_RIGHT |wxALL, 10);
    mainSizer->Fit(this);
    Center();
    //    SetSize(s);
}


void PasswordDlg::clear()
{
    passwordField->Clear();
}


int PasswordDlg::showWithCV( Certificate &certif, const wxSize &size, 
			     const wxString &oklabel, const bool displayCancel )
{
    cert= certif;
    okBtn = new wxButton(this,wxID_OK,oklabel);
  
    if(displayCancel)
	cancelBtn = new wxButton(this,wxID_CANCEL,_("Cancel"));
  
    btnSizer->Add(okBtn, 0,wxALIGN_CENTER |wxALL,5);
    
    if(displayCancel)
	btnSizer->Add(cancelBtn, 0, wxALIGN_CENTER | wxALL, 5);  
    
    okBtn->SetDefault();
    
    certificateViewerBtn = new wxButton(this, PDLG_CV_BTN, _("View certificate's details"));
    btnSizer->Add(certificateViewerBtn, 0,wxALIGN_CENTER |wxALL,5);
  
    mainSizer->Add(btnSizer, 0 ,wxEXPAND | wxALIGN_BOTTOM | wxALIGN_CENTER |wxALL,5);
    mainSizer->Fit(this);
    SetSize(size);
    Center();
    
    return ShowModal();
}


void PasswordDlg::onCVBtn(wxCommandEvent  &WXUNUSED(event))
{
    CertificateViewer cv(cert, user, this, -1 ,  _("Certificate properties"));
    cv.showModal(wxSize(435,500) , _("Close"), false); 
#ifdef DEBUG    
    std::cout << cert.getHash() << std::endl;  
#endif    
}
