/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#ifndef _PropertiesFrame_hh_
#define _PropertiesFrame_hh_

#include <wx/wx.h>
#include <wx/treectrl.h>

#include "Cryptonit.hh"

#include "../User.hh"
#include "../SoftKeyStore.hh"

#define CIPHER_NUM 14
#define DIGEST_NUM 7

using namespace Cryptonit ;

DECLARE_APP(CryptonitGui)

class PropertiesFrame: public wxDialog
{
private:

    User* user;
    SoftKeyStore *ks;
    
    std::vector< KeyStore *> *keyStores;

    wxStatusBar* userFrameStatusBar;
    wxNotebook* userFrameTab;

    wxListView* menu;
    wxBoxSizer* mainSizer;
    wxPanel* parametersPanel;

    wxBoxSizer* bottomSizer;
    wxStaticText* helpText;
    wxButton* applyBtn;

    /* CA */
    wxTreeCtrl *caTree;

    wxStaticText* caDNValue;
    wxStaticText* caSNValue;
    wxStaticText* caINValue;

    wxButton* removeCA;

    void onSelectCA(wxTreeEvent& event);
    void onActivateCA(wxTreeEvent& event);
    void onViewCertDetails(wxCommandEvent& WXUNUSED(event));
    void onAddCA(wxCommandEvent &WXUNUSED(event));
    void onRemoveCA(wxCommandEvent &WXUNUSED(event));
    void buildCATree();

    struct eqstr {
	bool operator()(const char* s1, const char* s2) const {
	    return s1 == s2;
	}
    };

    void addAllChilds( wxTreeItemId& parent, std::string certDN, 
		       hash_map<const char*, std::vector<std::string>, hash<const char*>, PropertiesFrame::eqstr>& adjacences );


    /* ID management */
    wxListBox *IDList;
    wxButton *deleteID;
    wxButton *addID;
    wxButton *viewCert;
    wxButton *certRequest;
    wxButton *exportP12;

    void onAddID(wxCommandEvent &WXUNUSED(event));
    void onDeleteID(wxCommandEvent &WXUNUSED(event));
    void onViewCert(wxCommandEvent &event);
    void onCertRequest(wxCommandEvent &WXUNUSED(event));
    void onExportP12(wxCommandEvent &WXUNUSED(event));
    void fillIDList();
    void updateIDList(Certificate &, pkcs12 &, const wxString &);

    /* Language selection */
    wxListBox* langList;

    
    /* Algorithms Selection */
    wxComboBox *encryptAlgo;
    wxComboBox *signatureAlgo;

    std::vector<std::string> *cipher;
    wxString *cipher_name;

    std::vector<std::string> *digest;
    wxString *digest_name;

    std::string selectedCipher;
    std::string selectedDigest;
    
    void onDigestChange(wxCommandEvent &event);
    void onCipherChange(wxCommandEvent &event);
    wxString getCipherName(std::string c);
    wxString getDigestName(std::string c);
    


    /* Address Book page */
    wxListBox* availableFields;
    wxListBox* selectedFields;
    wxBitmapButton* addBtn;
    wxBitmapButton* removeBtn;
    wxBitmapButton* upBtn;
    wxBitmapButton* downBtn;
    void onAvailableFieldsSelected(wxCommandEvent& event);
    void onSelectedFieldsSelected(wxCommandEvent& event);
    void onAddAvailableFields(wxCommandEvent& WXUNUSED(event));
    void onRemoveSelectedFields(wxCommandEvent& WXUNUSED(event));
    void onUpSelectedField(wxCommandEvent& WXUNUSED(event));
    void onDownSelectedField(wxCommandEvent& WXUNUSED(event));


    /* LDAP page */
    wxTextCtrl *serverName;
    wxTextCtrl *serverPort;
    wxTextCtrl *dn;
    wxTextCtrl *login;
    wxTextCtrl *passwd;
    wxButton *connectionTestBtn;
    wxListBox *ldapFieldsListBox;
    wxCheckBox *retain_LDAPv2;
    wxArrayString ldapFields;
    void onConnectionTest(wxCommandEvent &WXUNUSED(event));
  void onLDAPv2(wxCommandEvent &WXUNUSED(event));



    /* Crypto Hardware page */
    wxListCtrl *deviceList;
    wxButton *loadDevice;
    wxButton *unloadDevice;
    wxButton *restartP11lib;
    wxListBox *certList;
    std::vector<Certificate> p11cert;

    void fillDeviceList();
    void fillP11CertList(P11Manager * p11man);
	 void clearP11CertList();
    void loadDriver(wxCommandEvent &WXUNUSED(event));
    void unloadDriver(wxCommandEvent &WXUNUSED(event));
    void onSelectDriver(wxListEvent& event);
    void onSelectCertList(wxCommandEvent& event);
    void onRestartP11(wxCommandEvent &WXUNUSED(event));

    /* Pages selection */
  void createCAPage( wxPanel* panel );
  void createIDPage( wxPanel* panel );
  void createLanguagePage( wxPanel *panel );
  void createAlgosPage( wxPanel *panel );
  void createAddressBookPage( wxPanel *panel );
  void createLDAPPage( wxPanel *panel );
  void createDevicePage( wxPanel *panel );
  void createFolderPage( wxPanel *panel );
  void createSigningProfilePage( wxPanel *panel );
    void changePage( unsigned int page );
    unsigned int currentPage;

  /* Default folder */
  wxTextCtrl	*folderName;
  wxString	folderNameStr;
  wxButton	*defaultFolderBtn;
  wxCheckBox	*autoFill;

  void onDefaultFolder(wxCommandEvent &WXUNUSED(event));
  void onAutofill(wxCommandEvent &WXUNUSED(event));


  /* Signing profile */
  wxRadioButton *detachedRadio;
  wxRadioButton *attachedRadio;
  wxCheckBox *deleteCB;
  wxCheckBox *leaveCB;
  wxTextCtrl *targetDir;
  wxBitmapButton *dirBtn;

  void onSigningAttached(wxCommandEvent &WXUNUSED(event));
  void onSigningDetached(wxCommandEvent &WXUNUSED(event));
  void onSigningDeleteDB(wxCommandEvent &WXUNUSED(event));
  void onSigningLeaveCB(wxCommandEvent &WXUNUSED(event));
  void onSigningTarget(wxCommandEvent &WXUNUSED(event));

  void onSelectMenuItem(wxListEvent& event);
  void onApply(wxCommandEvent &WXUNUSED(event));
  void onCancel(wxCommandEvent &WXUNUSED(event));
  
  void createToolBar();
  void createStatusBar();
  
  void deleteParametersPanel();
  
    SoftKeyStore* getSoftKeyStore();

    DECLARE_EVENT_TABLE()

public:

    PropertiesFrame( wxWindow* parent, 
		     wxWindowID id, 
		     const wxString& title, 
		     User* u,
		     std::vector< KeyStore *> *_keyStores,
		     const wxPoint& pos = wxDefaultPosition, 
		     const wxSize& size = wxDefaultSize, 
		     long style = wxDEFAULT_FRAME_STYLE,
		     const wxString& name = _("Properties Frame"));
    
    
    ~PropertiesFrame();

    void displayPage( int index );
    
};

class CATreeItemData : public wxTreeItemData
{
public:
    CATreeItemData(const std::string& certFilename, const std::string& dn, const std::string& sdn) 
	: m_certFilename(certFilename), m_dn(dn), m_shortDn(sdn) {}
    const std::string GetCertFilename() const { return m_certFilename; }
    const std::string GetDN() const { return m_dn; }
    const std::string GetShortDN() const { return m_shortDn; }

private:
    std::string m_certFilename;
    std::string m_dn;
    std::string m_shortDn;
};

enum {
    PF_NOTEBOOK = 2100,
    PF_MENU_ID,
    PF_APPLY_BTN_ID,
    PF_CANCEL_BTN_ID,
    PF_CERT_TREE_ID,
    PF_VIEW_CERT_DETAILS_BTN_ID,
    PF_ADD_CA_BTN_ID,
    PF_REMOVE_CA_BTN_ID,
    PF_ENCRYPT_ALGO_ID,
    PF_SIGNATURE_ALGO_ID,
    PF_AVAILABLE_FIELDS_ID,
    PF_SELECTED_FIELDS_ID,
    PF_ADD_FIELDS_BTN_ID,
    PF_REMOVE_FIELDS_BTN_ID,
    PF_UP_SELECTED_FIELD_BTN_ID,
    PF_DOWN_SELECTED_FIELD_BTN_ID,
    PF_ID_LIST_ID,
    PF_ID_ADD_BTN_ID,
    PF_ID_DEL_BTN_ID,
    PF_ID_VIEW_BTN_ID,
    PF_ID_CERT_REQ_BTN_ID,
    PF_ID_EXPORT_BTN_ID,
    PF_LDAP_CONNECTION_TEST_ID,
    PF_LDAP_V2,
    PF_CRYPTO_LIST_ID,
    PF_CRYPTO_CERTLIST_ID,
    PF_CRYPTO_LOAD_BTN_ID,
    PF_CRYPTO_UNLOAD_BTN_ID, 
    PF_CRYPTO_RESTART_BTN_ID,
    PF_DEFAULT_FOLDER_ID,
    PF_AUTOFILL_ID,
    PF_ATTACHED_RADIO_ID,
    PF_DETACHED_RADIO_ID,
    PF_DELETE_CB_ID,
    PF_LEAVE_CB_ID,
    PF_TARGETDIR_BTN_ID
  };

#endif
   
