/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#include "RecipientsDlg.hh"
#include <iostream>

#include <wx/filename.h>

#include "Common.hh"
#include "../Contact.hh"
#include "../Certificate.hh"

//#include "pics/resources.h" //icons 
#ifndef __WXMSW__
#include "pics/add.xpm"
#include "pics/remove.xpm"
#endif


using namespace Cryptonit;

BEGIN_EVENT_TABLE (RecipientsDlg, wxDialog)
    EVT_BUTTON (RECDLG_ADD_BTN, RecipientsDlg::addRecipient)
    EVT_BUTTON (RECDLG_REMOVE_BTN, RecipientsDlg::removeRecipient)
    EVT_LIST_ITEM_SELECTED(RECDLG_AVAILABLE_LIST, RecipientsDlg::enableAddBtn)
    EVT_LIST_ITEM_SELECTED(RECDLG_SELECTED_LIST, RecipientsDlg::enableRemoveBtn)
    EVT_LIST_ITEM_DESELECTED(RECDLG_AVAILABLE_LIST, RecipientsDlg::disableAddBtn)
    EVT_LIST_ITEM_DESELECTED(RECDLG_SELECTED_LIST, RecipientsDlg::disableRemoveBtn)
    EVT_LIST_ITEM_ACTIVATED(RECDLG_AVAILABLE_LIST, RecipientsDlg::addRecipient2)
    EVT_LIST_ITEM_ACTIVATED(RECDLG_SELECTED_LIST, RecipientsDlg::removeRecipient2)
END_EVENT_TABLE()


/* Callback functions used by wxListCtrl::SortItems */
int wxCALLBACK compareRecipients(long item1, long item2, long sortData)
{
    User* user = (User*)sortData;

    std::string* dn1 = (std::string*)item1;
    std::string* dn2 = (std::string*)item2;

    return strcmp( user->addressBook->getContactInfo(*dn1, "cn").c_str(),
		   user->addressBook->getContactInfo(*dn2, "cn").c_str() );
}



RecipientsDlg::RecipientsDlg(wxWindow *parent, wxWindowID id,
			     Cryptonit::User *u,
			     const wxString &title,
			     const bool s)
    : CryptonitDlg(parent, id, title)
{
    signer = s;
    user = u;
    
    wxString boxTitle;
    if(signer)
	boxTitle = _("Choose the signer of these files");
    else 
	boxTitle = _("Choose the recipients for theses files");
    
    wxStaticBox *frame = new wxStaticBox(this, -1 , boxTitle);
    wxStaticBoxSizer *sizer = new wxStaticBoxSizer(frame,wxHORIZONTAL);
    wxBoxSizer *btnSizer = new wxBoxSizer(wxVERTICAL);
    

    long listFlag = wxLC_REPORT | wxLC_VRULES | wxLC_SORT_DESCENDING;
    /** Available & selected recipients lists creation **/
    if(signer){
	listFlag |=  wxLC_SINGLE_SEL;
    }

    availableRecipients = new wxListCtrl(this,RECDLG_AVAILABLE_LIST,
					 wxDefaultPosition, wxSize(200,300), listFlag );
    selectedRecipients = new wxListCtrl(this,RECDLG_SELECTED_LIST,
					wxDefaultPosition, wxSize(200,300), listFlag );


    availableRecipients->InsertColumn(0,_("Name"),wxLIST_FORMAT_LEFT,200);
    selectedRecipients->InsertColumn(0,_("Name"),wxLIST_FORMAT_LEFT,200);

    wxString availableTitle;
    wxString selectedTitle; 
    if(signer){
	availableTitle = _("Available signers");
	selectedTitle = _("Selected signer");
    }
    else {
	availableTitle = _("Available recipients");
	selectedTitle = _("Selected recipients");
    }
  
    wxStaticText *availableFrame = new wxStaticText(this,-1, availableTitle);
    wxBoxSizer *availableSizer = new wxBoxSizer(wxVERTICAL);
    availableSizer->Add(availableFrame);
    availableSizer->Add(availableRecipients, 1 ,wxEXPAND | wxALIGN_BOTTOM | wxALIGN_CENTER |wxALL,4);
    
    wxStaticText *selectedFrame = new wxStaticText(this,-1, selectedTitle);
    wxBoxSizer *selectedSizer = new wxBoxSizer(wxVERTICAL);
    selectedSizer->Add(selectedFrame);
    selectedSizer->Add(selectedRecipients, 1 ,wxEXPAND | wxALIGN_BOTTOM | wxALIGN_CENTER |wxALL,4);


    /** add & remove buttons creation **/
    wxBitmap addIcon = wxBITMAP(add);
#ifdef __WXMSW__
    addIcon.SetMask( new wxMask(addIcon, wxColour(0xC0,0xC0,0xC0)) );
#endif
    add = new wxBitmapButton(this, RECDLG_ADD_BTN , addIcon);

    wxBitmap remIcon = wxBITMAP(remove);
#ifdef __WXMSW__
    remIcon.SetMask( new wxMask(remIcon, wxColour(0xC0,0xC0,0xC0)) );
#endif
    remove = new wxBitmapButton(this, RECDLG_REMOVE_BTN , remIcon);
  


    /** no item selected ->disable buttons **/
    add->Disable();
    remove->Disable(); 

    if(signer)
	fillAvailableSigners();
    else
	fillAvailableRecipients();

    btnSizer->Add(add, 0, wxEXPAND | wxALIGN_CENTER_VERTICAL | wxBOTTOM | wxTOP, 20);
    btnSizer->Add(remove, 0, wxEXPAND | wxALIGN_CENTER_VERTICAL | wxTOP, 20);

    sizer->Add(availableSizer, 1 ,wxEXPAND | wxALIGN_BOTTOM | wxALIGN_CENTER | wxALL, 15); 
    sizer->Add(btnSizer,0,wxEXPAND | wxALIGN_CENTER_VERTICAL | wxALL, 15);
    sizer->Add(selectedSizer, 1, wxEXPAND | wxALIGN_BOTTOM | wxALIGN_CENTER | wxALL, 15);

    mainSizer->Add(sizer, 1 ,wxEXPAND |wxCENTER |wxALL,5);
   
}


RecipientsDlg::~RecipientsDlg()
{
    for( int i=0 ; i < availableRecipients->GetItemCount() ; i++ ) {
	std::string *data = (std::string*) availableRecipients->GetItemData( i );
	if( data ) delete data;
    }
    
    for( int i=0 ; i < selectedRecipients->GetItemCount() ; i++ ) {
	std::string *data = (std::string*) selectedRecipients->GetItemData( i );
	if( data ) delete data;
    }

}


void  RecipientsDlg::fillAvailableRecipients()
{
    if( user->addressBook != NULL ) {
	std::vector<std::string>*names = user->addressBook->getAllContactName();
	std::vector<std::string>::iterator itr;
	long i = 0;

	for( itr = names->begin(); itr != names->end(); itr++ ) {
	  
	    Certificate c;
	    wxFileName certFile(std2wx(user->addressBook->getContactInfo
																 (*itr, "userCertificate")));
	    certFile=wxMyPrepend(certFile,std2wx(user->getCertificatesDir()));

	    if(c.load(wx2std(certFile.GetFullPath()).c_str()) == SUCCESS){
		if(c.isForEncrypting() ||  c.isForSigningAndEncrypting()){
		    wxListItem item;
		    item.SetId(i);
		    item.SetColumn(0);
		    item.SetMask(wxLIST_MASK_TEXT | wxLIST_MASK_DATA);
		    
		    std::string *data = new std::string( *itr );
		    item.SetData( (void*)data );
		    
		    item.SetText(std2wx(user->addressBook->getContactInfo(*itr, "cn")));
		    availableRecipients->InsertItem( item );
		    i++;
		}
	    }
	}

	/* Sort recipients, using wxLC_SORT_ flag */
	availableRecipients->SortItems(compareRecipients, (long)user);
	
	names->clear();
	delete names;
    }
}


void  RecipientsDlg::fillAvailableSigners()
{
    if( user->addressBook != NULL ) {
	std::vector<std::string>* names = user->addressBook->getAllContactName();
	std::vector<std::string>::iterator itr;
	long i = 0;
	
	for( itr = names->begin(); itr != names->end(); itr++ ) {
	    
	    Certificate c;
	    wxFileName certFile(std2wx(user->addressBook->getContactInfo(*itr, "userCertificate")));
	    certFile=wxMyPrepend(certFile,std2wx(user->getCertificatesDir()));

	    if(c.load(wx2std(certFile.GetFullPath()).c_str()) == SUCCESS) {
		if(c.isForSigning() ||  c.isForSigningAndEncrypting()){
		    wxListItem item;
		    item.SetId(i);
		    item.SetColumn(0);
		    item.SetMask(wxLIST_MASK_TEXT | wxLIST_MASK_DATA);
		    
		    std::string *data = new std::string( *itr );
		    item.SetData( (void*)data );
		    
		    item.SetText(std2wx(user->addressBook->getContactInfo(*itr, "cn")));
		    availableRecipients->InsertItem( item );
		    i++;
		}
	    }
	}

	/* Sort recipients, using wxLC_SORT_ flag */
	availableRecipients->SortItems( compareRecipients, (long)user );
	
	names->clear();
	delete names;
    }
}





void RecipientsDlg::addRecipient2(wxListEvent &WXUNUSED(event))
{
		wxCommandEvent e;
		this->addRecipient(e);
}

void RecipientsDlg::addRecipient(wxCommandEvent &WXUNUSED(event))
{
    long id = availableRecipients->GetNextItem(-1,wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);

    while(id != -1) {
	wxListItem selectedItem ;

	selectedItem.SetId(id);
	selectedItem.SetColumn(0);
	selectedItem.SetMask(wxLIST_MASK_TEXT | wxLIST_MASK_DATA);

	//get the selected item
	if(availableRecipients->GetItem(selectedItem)) {
	    selectedItem.SetId(selectedRecipients->GetItemCount());
	    
	    selectedRecipients->InsertItem( selectedItem );
	    
	    availableRecipients->DeleteItem(id);
	    id = availableRecipients->GetNextItem(-1,wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	}
    }
    
    if(signer)
	add->Disable();
    else
	add->Enable(availableRecipients->GetItemCount()>0);
  
}

void RecipientsDlg::removeRecipient2(wxListEvent &WXUNUSED(event))
{
		wxCommandEvent e;
		this->removeRecipient(e);
}

void RecipientsDlg::removeRecipient(wxCommandEvent &WXUNUSED(event))
{
    long id = selectedRecipients->GetNextItem(-1,wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);

    while(id != -1) {
	wxListItem selectedItem ;

	selectedItem.SetId(id);
	selectedItem.SetColumn(0);
	selectedItem.SetMask(wxLIST_MASK_TEXT | wxLIST_MASK_DATA);

	//get the selected item
	if(selectedRecipients->GetItem(selectedItem)) {
	    selectedItem.SetId(availableRecipients->GetItemCount());
	
	    availableRecipients->InsertItem(selectedItem);
	    
	    selectedRecipients->DeleteItem(id);
	    id = selectedRecipients->GetNextItem(-1,wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	}
    }
  
    if(signer)
	remove->Disable();
    else 
	remove->Enable(selectedRecipients->GetItemCount()>0);
}


std::vector<wxString> *RecipientsDlg::getRecipientList()
{
    if( selectedRecipients->GetItemCount() == 0 ) 
	return NULL;

    std::vector<wxString>* result = new std::vector<wxString>();

    for( int i = 0 ; i < selectedRecipients->GetItemCount(); i++ ) {
	wxListItem item;

	item.SetId(i);
	item.SetColumn(0);
	item.SetMask(wxLIST_MASK_TEXT | wxLIST_MASK_DATA);

	selectedRecipients->GetItem(item);
#ifdef DEBUG	
	std::cout << item.GetText() << std::endl;
#endif	

	std::string *name = (std::string *)item.GetData();

	if(name == NULL) {
#ifdef DEBUG		
	    std::cout << "data == NULL" << std::endl;
#endif	    
	} else {
#ifdef DEBUG		
	    std::cout << *name << std::endl;
#endif	    
	    result->push_back( std2wx(*name) /*selectedRecipients->GetItemText(i)*/ );
	}
    }
    
    return result;
}



wxString RecipientsDlg::getRecipient()
{
    if( selectedRecipients->GetItemCount() == 0 ) 
				return wxString(_T(""));

    wxListItem item;
    item.SetId(0);
    item.SetMask(wxLIST_MASK_TEXT | wxLIST_MASK_DATA);
    item.SetColumn(0);
    selectedRecipients->GetItem(item);
    std::string *name = (std::string *)item.GetData();

    return wxString(std2wx(*name));
}


void RecipientsDlg::enableAddBtn(wxListEvent &WXUNUSED(event))
{
    if(signer)
	add->Enable(selectedRecipients->GetItemCount()==0);
    else 
	add->Enable();
}

void RecipientsDlg::enableRemoveBtn(wxListEvent &WXUNUSED(event))
{
    remove->Enable();
}

void RecipientsDlg::disableAddBtn(wxListEvent &WXUNUSED(event))
{
    add->Disable();
}

void RecipientsDlg::disableRemoveBtn(wxListEvent &WXUNUSED(event))
{
    remove->Disable();
}


