#ifndef _AES_H_
#define _AES_H_

#include "types.h"

#undef FULL_UNROLL
#define AES_ENCRYPT	1
#define AES_DECRYPT	0
#define AES_MAXNR 14
#define AES_BLOCK_SIZE 16

typedef struct
{
    uint32 rd_key[4 *(AES_MAXNR + 1)];
    int32 rounds;
}	aes_ctx;

void aes_set_key(aes_ctx * ctx, const uint8 *key, uint32 keybits, int enc);
void aes_cbc_encrypt(aes_ctx * ctx, uint8 *iva, uint8 *data, uint32 len);
void aes_cbc_decrypt(aes_ctx * ctx, uint8 *iva, uint8 *data, uint32 len);

/* Warning untested */

void aes_ecb_encrypt(aes_ctx * ctx, uint8 *data, uint32 len);
void aes_ecb_decrypt(aes_ctx * ctx, uint8 *data, uint32 len);

#endif
