#!/usr/bin/perl
# This file is copyright (C) 2001 Andrew Suffield
#                                  <asuffield@freenode.net>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

use warnings;
use strict;

chdir "debug-tree" if -e "debug-tree";
open(CONF, "proxy.rc")
  or die "Can't open proxy.rc: $!\n";
while(my $line = <CONF>)
  {
    next if $line =~ /^\s*(\#.*)?$/; # Comments and lines containing only whitespace
    my ($name, undef, undef) = $line =~ /(.*),(.*),(.*)/
      or die "proxy.rc not in expected format (found '$line' which didn't match)\n";
    print "cd $name && ../ircd -d .\n";
    system("cd $name && ../ircd -d .");
  }
close CONF;
exec "./proxy"
  or die "Couldn't exec ./proxy\n";
