/*
 * Danpei -- a GTK+ based Image Viewer
 * Copyright (C) 2001-2003 Shinji Moiino
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/* help_menu.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdkx.h>

#include "config.h"
#include "help_menu.h"
#include "intl.h"
#include "typedefs.h"
#include "version.h"

/* Static function declarations. */
static void help_menu_cb_about_ok (GtkWidget*,
                                   gpointer    );

/* Function definitions. */
/* 
 * @help_menu_cb_about
 *
 *  Display the version information.
 *
 */
void help_menu_cb_about (GtkWidget *widget,
                         gpointer  data   ,
                         guint     action   ) {
  TopLevel  *tp;
  GtkWidget *dialog;
  GtkWidget *frame;
  GtkWidget *vbox;
  GtkWidget *msg_label;
  GtkWidget *button;
  gchar     title[256];

  /* Initialize the local variables. */
  tp = (TopLevel*)data;

  dialog = gtk_dialog_new();
  gtk_window_set_title(GTK_WINDOW(dialog), _("About"));
  gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
  gtk_window_set_transient_for(GTK_WINDOW(dialog), GTK_WINDOW(tp->window));
  gtk_signal_connect(GTK_OBJECT(dialog), 
                     "delete-event",
                     GTK_SIGNAL_FUNC(help_menu_cb_about_ok), tp);

  frame = gtk_frame_new(NULL);
  gtk_container_border_width(GTK_CONTAINER(frame), 8);

  vbox = gtk_vbox_new(TRUE, 2);
  gtk_container_border_width(GTK_CONTAINER(vbox), 4);

  msg_label = gtk_label_new("        ");
  gtk_box_pack_start(GTK_BOX(vbox), msg_label, TRUE, TRUE, 0);
  gtk_widget_show(msg_label);

  sprintf(title, "         Danpei version %s          ", VERSION);
  msg_label = gtk_label_new(title);
  gtk_box_pack_start(GTK_BOX(vbox), msg_label, TRUE, TRUE, 0);
  gtk_widget_show(msg_label);
  msg_label = gtk_label_new("        ");
  gtk_box_pack_start(GTK_BOX(vbox), msg_label, TRUE, TRUE, 0);
  gtk_widget_show(msg_label);
  msg_label = gtk_label_new("      (C)2001-2005  Shinji Morino      ");
  gtk_box_pack_start(GTK_BOX(vbox), msg_label, TRUE, TRUE, 0);
  gtk_widget_show(msg_label);
  msg_label = gtk_label_new("        ");
  gtk_box_pack_start(GTK_BOX(vbox), msg_label, TRUE, TRUE, 0);
  gtk_widget_show(msg_label);
  msg_label = gtk_label_new(" http://www.asahi-net.or.jp/~wp7s-mrn/ ");
  gtk_box_pack_start(GTK_BOX(vbox), msg_label, TRUE, TRUE, 0);
  gtk_widget_show(msg_label);
  msg_label = gtk_label_new("    http://danpei.sourceforge.net/     ");
  gtk_box_pack_start(GTK_BOX(vbox), msg_label, TRUE, TRUE, 0);
  gtk_widget_show(msg_label);
  msg_label = gtk_label_new("      <peace24@blue.email.ne.jp>       ");
  gtk_box_pack_start(GTK_BOX(vbox), msg_label, TRUE, TRUE, 0);
  gtk_widget_show(msg_label);
  msg_label = gtk_label_new("        ");
  gtk_box_pack_start(GTK_BOX(vbox), msg_label, TRUE, TRUE, 0);
  gtk_widget_show(msg_label);

  gtk_widget_show(vbox);
  gtk_container_add(GTK_CONTAINER(frame), vbox);
  gtk_widget_show(frame);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), 
                     frame, TRUE,TRUE, 0);

  button = gtk_button_new_with_label(_("   OK   "));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), 
                     button, FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT(button), 
                     "clicked",
                     GTK_SIGNAL_FUNC(help_menu_cb_about_ok), tp);

  GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default(button);
  gtk_widget_grab_focus(button);
  gtk_widget_show(button);

  gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
  gtk_widget_show(dialog);

  gtk_main();

  gtk_widget_destroy(dialog);

  return;
}

/* Static functions definition. */
/*
 * @help_menu_cb_about_ok
 *
 *
 *
 */
static void help_menu_cb_about_ok(GtkWidget *widget,
                                  gpointer  data     ) {
  gtk_main_quit();

  return;
}



