//Please refer to http://dansguardian.org/?page=copyright2
//for the license for this code.
//Written by Daniel Barron (daniel@//jadeb/.com).
//For support go to http://groups.yahoo.com/group/dansguardian

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "autoconf/platform.h"
#ifndef __HPP_FDTUNNEL
#define __HPP_FDTUNNEL
#include <iostream>
#ifdef __BSD
#include "autoconf/select.h"
#include <sys/types.h>
#else
#include <sys/select.h>
#endif

class FDTunnel
{

public:
  FDTunnel ();
  void tunnel (int fdfrom, int fdto);
  int throughput;               // used to log total data from from to to
private:
  int read (int fd, char *buff, int len);
  bool write (int fd, char *buff, int len);
  int selectEINTR (int numfds, fd_set * readfds, fd_set * writefds, fd_set * exceptfds, struct timeval *timeout);
};

#endif
